<?php

namespace App\Modules\baner\Controllers;

use \App\Models\common\MODEL__global;
use \App\Models\MODEL__offer_isOpen;
use \App\Models\common\MODEL__all_oferta;

class Baner extends \App\Controllers\BaseController {

    protected MODEL__all_oferta $MODEL__all_oferta;
    protected MODEL__global $MODEL__global;
    protected $viewPath = 'Modules\baner\Views\\';
    protected $tip      = 'baner';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        helper('url');
    }

    public function index($id = null) {

        $settings = service('settings');
        $general  = $settings -> get('App.general') ?? [];
        $preval   = $settings -> get('App.general')['preval'] ?? [];

        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add('Поръчки', '/');

        $folder_forDocumetns = '';

        $zenovaLista = $this -> MODEL__global -> get__zenovaLista();

        if (is_numeric($id)) {
            $this -> session -> set('oferId', $id);
            $this -> session -> set('openedTab', $this -> tip);

            $folder_forDocumetns = glob(dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . 'documents/' . $this -> tip . '/' . $id . '/*.*');
            // dd( dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . 'documents/' . $this -> tip . '/' . $id );
        }

        $data = [
            'page_title'             => lang('LANG__special.breadcrumbs.info'),
            'breadcrumbs'            => $this -> breadcrumb -> render(),
            'addCSS'                 => $this -> addCSS(),
            'addJS'                  => $this -> addJS(),
            'ofer'                   => $this -> MODEL__all_oferta -> get__ofer_by_id($id, $this -> tip),
            'status'                 => $this -> MODEL__global -> get__status(),
            'shablon'                => $this -> MODEL__global -> get__shablons(),
            'list'                   => $this -> MODEL__all_oferta -> get__products_forOfer($id, $this -> tip),
            'mqrka'                  => $this -> MODEL__global -> get__mqrka(),
            'valuta'                 => $this -> MODEL__global -> get__valuta(),
            'languages'              => $this -> MODEL__global -> get__languages(),
            'general'                => $general,
            'preval'                 => $preval,
            // ако има снимки прикачени се извличат
            'uploads'                => glob('uploads/baner/' . $id . '/*.*'),
            'get_documents'          => ['docs' => $folder_forDocumetns, 'tab' => $this -> tip, 'orderId' => $id],
            'modulTip'               => $this -> tip,
            // VIEWS -----------------------------------------------------
            'view_global_klientData' => 'common/VIEW__glob-klientData',
            'view_leftAside'         => $this -> viewPath . 'VIEW__baner-leftAside',
            'view_htmlTable'         => $this -> viewPath . 'VIEW__baner-table',
            'view_files'             => $this -> viewPath . 'VIEW__baner-files',
            'view_actionBtn'         => $this -> viewPath . 'VIEW__baner-actionBtn',
            'view_documents_inModul' => 'common/VIEW__documents-inModul', // таблица с прикачени файлове
        ];

        return $this -> render_template($this -> viewPath . 'VIEW__baner', $data);
    }

    // превръщане  на оферта в поръчка
    public function clone() {

        $id       = $this -> request -> getVar('id');
        $tab      = $this -> request -> getVar('tab');
        $oferName = $this -> request -> getVar('oferName');

        $data = [
            'id'         => $id,
            'tab'        => $tab,
            'oferName'   => $oferName,
            'userCreate' => $this -> user -> username,
        ];

        $response = $this -> MODEL__all_oferta -> clone_ofer($data);

        return json_encode($response);
    }

    public function submit($id = null) {

        $form = json_decode($this -> request -> getVar('form'), true);

        $form['baner'] = $this -> changeArr($form['baner'] + ($form['colorRows'] ?? []), [
            'all'    => [
                'json' => [
                    'colorRows',
                    'qtyPrice_json'
                ],
                'imp'  => ['productsID']
            ],
            'update' => [
                'user' => 'userName_modify',
                'date' => 'date_update'
            ],
            'create' => [
                'user' => 'userName_create',
                'date' => 'date_create' // име на sql колоната 
            ]
                ], $id, true);

        $response = $this -> MODEL__all_oferta -> save_order($id, $form, $this -> tip);

        if (isset($response['err'])) {
            return json_encode($response, JSON_UNESCAPED_UNICODE);
        }

        // ако е нова оферта се заклучва към потребителя който я е създал
        if (!is_numeric($id) && !empty($response)) {
            $MODEL__offer_isOpen = new MODEL__offer_isOpen();
            $MODEL__offer_isOpen -> checkAndLockOffer($response, $this -> tip, $this -> user -> id);
        }

        return json_encode(['url' => route_to('Baner-edit', $response)]); // last id на оферта ако е нова оферта
    }

    // изтриване на оферта
    public function delete($id = null) {

        if ($id) {
            $this -> MODEL__all_oferta -> delete_oferta(['id' => $id, 'tab' => $this -> tip]);
            return redirect() -> to(html_entity_decode(route_to('tabBaner')));
        }
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'plugins/currency-flags/currency-flags',
            'css/layouts/autocomplete',
            'css/layouts/global',
            'css/layouts/tables',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/choose-color/choose-color',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/timepicker/datepicker',
            'plugins/ssi_uploaderImage/styles/ssi-uploader',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/klient_modify_inOfer',
            'js/_Global/inOfer/leftAsideActions',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/ssi_uploaderImage/js/ssi-uploader',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/timepicker/datepicker',
            'plugins/choose-color/choose-color',
        ];
        $default = ['js/modul/baner/baner'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
