<?php

namespace App\Models\spisak;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
use \App\Models\BaseModel as BaseModel;

class MODEL__product extends BaseModel {

    // изв. на всички продукти
    function get__all_product($searchName = null, $categoryId = null, $col = null, $sort = [], $limit = []) {

        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' z', 'product_id', 'left')
                -> join(self::TBL_PRODUCT_IN_ZENOVALISTA . ' pz', 'product_id', 'left')
                -> join(self::TBL_BRAND . ' b', 'brand_id', 'left')
                -> join(self::TBL_PRODUCT_SITES . ' ps', 'product_id', 'left')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                -> join('(SELECT category_id as cid,category_name AS category_name FROM ' . self::TBL_CATEGORY . ' ) as c', 'c.cid = p.categoryRoot_id', 'left')
                -> join('(SELECT parent_id as pid,category_name AS subCategory_name FROM ' . self::TBL_CATEGORY . ' ) as cs', 'cs.pid=p.category_id', 'left')
                -> groupBy('p.product_id');

        // филтър по категория
        if ($categoryId) {
            $sql -> where('p.categoryRoot_id', $categoryId);
        }

        // филтър по име и колона
        if ($searchName && $col) {
            $sql -> like("$col", $searchName, 'both');
        }
        if ($sort['col']) {
            //$sql -> orderBy($sort['col'], $sort['sortOrder']);
        } else {
            //$sql -> orderBy('id', 'ASC');
        }
        if ($limit) {
            $sql -> limit($limit['per_page'], $limit['offset']);
        }

        return $sql -> get() -> getResultArray();
    }

    function save_nalich($productIds = [], $value = null) {
        $query = $this -> db -> table(self::TBL_PRODUCT) -> set('nalichnost', $value);

        // обновява селекция продукти с наличност
        if (!empty($productIds)) {
            $query -> whereIn('product_id', $productIds);
        }

        $query -> update();
    }

    function change_categoryOnProducts($selectedCategoryId = '', $productIds = []) {
        $this -> db -> table(self::TBL_PRODUCT)
                -> set('categoryRoot_id', $selectedCategoryId)
                -> set('category_id', null)
                -> whereIn('product_id', $productIds)
                -> update();
    }

    // === клониране на продукт ====
    // -----------------------------
    function clone_product($id = '', $newProductName = '') {
        $found = $this -> db -> table(self::TBL_PRODUCT)
                -> where('product_name', $newProductName)
                -> countAllResults();

        if ($found > 0) {
            return ['dub' => true];
        }

        $clone_row = $this -> db -> table(self::TBL_PRODUCT)
                        -> where('product_id', $id)
                        -> get() -> getRowArray();

        unset($clone_row['product_id']);
        unset($clone_row['date_product_create']);

        $clone_row['date_product_create'] = date("d-m-Y H:i");
        $clone_row['product_name']        = $newProductName;

        $this -> db -> table(self::TBL_PRODUCT) -> insert($clone_row);
    }

    // === изтриване на продукт ====
    // -----------------------------
    function delete_product($id = '', $productName = '') {
        if ($id) {
            $orderName   = '';
            $specialName = '';
            $zenovaName  = '';

            $order = $this -> db -> table(self::TBL_ORDER)
                            -> select('order_id')
                            -> where("JSON_EXTRACT(product_json, '$.\"$id\"') IS NOT NULL")
                            -> get() -> getResultArray();

//            $special = $this -> db -> table(self::TBL_SPECIAL)
//                            -> select('offersName')
//                            -> where("FIND_IN_SET($id,productsID)>0")
//                            -> groupBy('productsID')
//                            -> get() -> getResultArray();

            $zenova = $this -> db -> table(self::TBL_PRODUCT_IN_ZENOVALISTA . ' pz')
                            -> select('z.offersName')
                            -> join(self::TBL_ZENOVA_LISTA . ' z', 'z.id =pz.zenovaLista_id', 'inner')
                            -> where('pz.product_id', $id)
                            -> get() -> getResultArray();

            if ($order != []) {
                $orderName = implode(',', array_map(function ($n) {
                            return $n['order_id'];
                        }, $order));
            }
//            if ($special != []) {
//                $specialName = implode(',', array_map(function ($n) {
//                            return $n['offersName'];
//                        }, $special));
            // }
            if ($zenova != []) {
                $zenovaName = implode(',', array_map(function ($n) {
                            return $n['offersName'];
                        }, $zenova));
            }

            if ($zenova == [] && $order == []) {
                $this -> db -> table(self::TBL_PRODUCT) -> where('product_id', $id) -> delete();
            } else {
                return ['orderName' => $orderName, 'specialName' => $specialName, 'zenovaName' => $zenovaName];
            }
        }
    }

    // === копиране на оферта ====
    // --------------------------
//    function copy_ofer($data = [], $arg = '') {
//
//        $sqlTable = match ($arg) {
//            'special' => $this -> tbl_special,
//            'order' => $this -> tbl_order,
//        };
//
//        $clone_row = $this -> db -> table($sqlTable)
//                        -> where('id', $data['id'])
//                        -> get() -> getRow();
//
//        unset($clone_row -> id);
//        unset($clone_row -> userName_modify);
//        unset($clone_row -> date_update);
//        unset($clone_row -> lockRowState);
//
//        $clone_row -> userName_create = $data['userName'];
//        $clone_row -> offersName      = $data['oferName'];
//        $clone_row -> date_create     = date("d-m-Y H:i");
//
//        $this -> db -> table($sqlTable) -> insert((array) $clone_row);
//    }
//   
//
//    // проверка дали офертата се използва
//    // ===================================
//    function ajax_checkeLockStage($sqlTable, $id) {
//        return $this -> db -> table($sqlTable) -> select('lockRowState') -> where('id', $id) -> get() -> getRowObject();
//    }
//
//    // ########################################################################
//    // | ------------------------ favorites  ---------------------------------|
//    // ########################################################################
//    // извличане на favorites за конкретен user
//    // ==========================================
//    function get_favorites($userID) {
//        return $this -> db -> table('_favorites') -> select('*') -> where('userID', $userID) -> get() -> getResultArray();
//    }
//
//    // запис на favorites за конкретен user
//    // =====================================
//    function ajax_save_favorites($data = []) {
//        $this -> db -> table('_favorites') -> insert($data);
//
//        return $this -> db -> insertID();
//    }
//
//    // обновяване на favorites за конкретен user
//    // =====================================
//    function ajax_update_favorites($id, $data = []) {
//        echo $this -> db -> table('_favorites') -> update($data, 'id=' . $id);
//    }
//
//    // изтриване на favorites за конкретен user
//    // =========================================
//    function ajax_delete_favorites($id) {
//        $this -> db -> table('_favorites') -> where('id', $id) -> delete();
//    }
}
