<?php

namespace App\Models\spisak;

use \App\Models\BaseModel as BaseModel;

class MODEL__klient extends BaseModel {

    // изв. на всички продукти
    function get__all_klient($tab = null, $searchName = null, $col = null, $sort = [], $limit = []) {

        $sql = $this -> db -> table(self::TBL_KLIENT);

        // филтър по име и колона
        if ($searchName && $col) {
            $sql -> like($col, $searchName, 'both');
        }

        if ($sort && $sort['col']) {
            $sql -> orderBy($sort['col'], $sort['sortOrder']);
        } else {
            $sql -> orderBy('klient_id', 'DESC');
        }
        if ($limit) {
            $sql -> limit($limit['per_page'], $limit['offset']);
        }

        $sql -> where($tab == 'klient' ? "gensoft_firm_id is NULL" : "gensoft_firm_id is not NULL")
                -> where('isActive', 'Y');

//dd($sql -> getCompiledSelect());
        return $sql -> get() -> getResultArray();
    }

    function get__klient($id) {

        return $this -> db -> table(self::TBL_KLIENT)
                        -> where('klient_id', $id)
                        -> get() -> getResultArray();
    }

    function change_priceLevel($selectedPriceLevel = '', $klientIds = []) {

        $klientIds = is_array($klientIds) ? $klientIds : [$klientIds];

        if (!empty($klientIds)) {
            $this -> db -> table(self::TBL_KLIENT)
                    -> set('zenaNivo', $selectedPriceLevel)
                    -> whereIn('klient_id', $klientIds)
                    -> update();
        }
    }

    // === изтриване на клиент ====
    // -----------------------------
    function delete_klient($id = '') {
        if ($id) {
            $this -> db -> table(self::TBL_KLIENT)
                    -> set('isActive', null)
                    -> where('klient_id', $id)
                    -> update();
        }
    }

    //бр на всички продукти 
    function count__all_klient($tab = null, $col = '', $searchName = null) {

        $sql = $this -> db -> table(self::TBL_KLIENT)
                -> select('klient_id')
                -> where($tab == 'klient' ? 'gensoft_firm_id is NULL' : 'gensoft_firm_id is not NULL')
                -> where('isActive', 'Y');

        if ($searchName) {
            $sql -> like($col, $searchName, 'both');
        }

        return $sql -> countAllResults();
    }

}
