<?php

namespace App\Models\mainPage;

use \App\Models\BaseModel as BaseModel;

class MODEL__mainPage extends BaseModel {

    public function __construct() {
        parent::__construct();
    }

    // извл. на записи за конкретен таб в list
    // =============================================
    function get__list($tab = null, $searchName = null, $searchCol = null, $sort = [], $limit = []) {
        if (!$tab || !array_key_exists($tab, self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }
        $orderTip = $_GET['orderTip'] ?? null;
        $promoTip = $_GET['promoTip'] ?? null;

        $table = match (true) {
            $tab == 'order' && in_array($orderTip, ['site', 'L', 'K', 'F']) => self::TBL_ORDER,
            $tab == 'order' && $orderTip == 'N' => self::TBL_ORDERCART,
            $tab == 'order' => self::TBL_ORDER_GENSOFT,
            $tab == 'promo' && $promoTip == 'D' => self::TBL_PROMO,
            $tab == 'promo' && $promoTip == 'K' => self::TBL_PROMOKL,
            default => self::TABLES[$tab] ?? null,
        };

        $sql = $this -> db -> table($table . ' o');

        $joins = [
            'k'  => 'klient_id',
            'st' => 'sp_status_id'
        ];

        foreach ($joins as $alias => $field) {
            if ($this -> db -> fieldExists($field, $table)) {
                $sql -> join(self::TABLES2[$alias] . ' ' . $alias, $field, 'left');
            }
        }

        if ($searchName) {
            // $defaultCol = ($tab == 'dostavka') ? 'dostavka_name' : 'offersName';
            $sql -> like($searchCol ?? 'offersName', $searchName, 'both');
        }

        if ($tab == 'order') {
            match ($orderTip) {
                'L', 'K', 'F', 'N' => $sql -> where('o.orderTip', $_GET['orderTip']),
                default => $sql -> where('o.orderTip', NULL)
            };
        }

        $sortCol = $sort['col'] ?? match (true) {
                    $tab === 'order' && $orderTip === 'N' => "STR_TO_DATE(date_added, '%d-%m-%Y')",
                    $tab === 'order' => 'order_id',
                    $tab === 'zenova' => 'offersName',
                    default => 'id',
                };

        $sortOrder = $sort['sortOrder'] ?? match ($tab) {
                    'order' => 'DESC',
                    'zenova' => 'ASC',
                    default => 'DESC',
                };

        if ($sortCol == 'date_create') {
            $sortCol = "STR_TO_DATE(date_create, '%d-%m-%Y')";
        }

        $sql -> orderBy($sortCol, $sortOrder, false);

        if (isset($limit)) {
            $sql -> limit($limit['per_page'], $limit['offset']);
        }
        //dd($sql -> getCompiledSelect());
        //dd($sql -> get() -> getResultArray());
        return $sql -> get() -> getResultArray();
    }

    // извл. на доставчиците (те са от Gensoft)
    // ======================================
    function get__providers() {

        $group_provider = $this -> db -> table('_provider_group')
                        -> orderBy('provider_group_name', 'ASC')
                        -> get() -> getResultArray();

        $provider_inGroup = $this -> db -> table('_provider_inGroup')
                        -> join('_provider', 'provider_id', 'inner')
                        -> get() -> getResultArray();

        $provider = $this -> db -> table('_provider')
                        -> get() -> getResultArray();

        return ['group' => $group_provider, 'provider_inGroup' => $provider_inGroup, 'provider' => $provider];
    }

    function count_totalRecords($tab = '', $searchName = null, $searchCol = null, $sort = []) {
        if (!$tab || !array_key_exists($tab, self::TABLES)) {
            return 0; // Return 0 for invalid or empty tab
        }

        $orderTip = $_GET['orderTip'] ?? null;
        $promoTip = $_GET['promoTip'] ?? null;

        $table = match (true) {
            $tab == 'order' && in_array($orderTip, ['site', 'L', 'K', 'F']) => self::TBL_ORDER,
            $tab == 'order' && $orderTip == 'N' => self::TBL_ORDERCART,
            $tab == 'order' => self::TBL_ORDER_GENSOFT,
            $tab == 'promo' && $promoTip == 'D' => self::TBL_PROMO,
            $tab == 'promo' && $promoTip == 'K' => self::TBL_PROMOKL,
            default => self::TABLES[$tab] ?? null,
        };

        $sql = $this -> db -> table($table . ' o');

        $joins = [
            'k'  => 'klient_id',
            'st' => 'sp_status_id'
        ];

        foreach ($joins as $alias => $field) {
            if ($this -> db -> fieldExists($field, $table)) {
                $sql -> join(self::TABLES2[$alias] . ' ' . $alias, $field, 'left');
            }
        }

        if (!empty($searchName)) {
            $sql -> like($searchCol ?? 'offersName', $searchName, 'both');
        }

        //  ако сме в таб razl ot site
        if (!empty($orderTip)) {
            $sql -> where('orderTip', $orderTip == 'site' ? NULL : $orderTip);
        }
        //dd($sql -> getCompiledSelect());
        return $sql -> countAllResults();
    }

    // копиране на оферта 
    // ==================
    function copy_ofer($data = [], $tab = '') {

        if (!$tab || !array_key_exists($tab, self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }

        $clone_row = $this -> db -> table(self::TABLES[$tab])
                        -> where('id', $data['id'])
                        -> get() -> getRow();

        // max custom id за принт офертата otdolu
        // проверка дали колона CustomNo съществува
        if ($this -> db -> fieldExists('customNo', self::TABLES[$tab])) {
            $CustomNo = $this -> db -> table(self::TABLES[$tab])
                            -> select('max(CustomNo) as customNo')
                            -> get() -> getRow();

            $clone_row -> customNo = $CustomNo -> customNo != '' ? $CustomNo -> customNo + 1 : '21501';
        }

        // Unset unnecessary fields
        $fieldsToUnset = ['id', 'userName_modify', 'date_update', 'is_open', 'locked_by'];
        foreach ($fieldsToUnset as $field) {
            unset($clone_row -> $field);
        }

        $clone_row -> userName_create = $data['userName'];
        $clone_row -> offersName      = $data['oferName'];
        $clone_row -> date_create     = date("d-m-Y H:i");

        try {
            $this -> db -> transBegin();

            $this -> db -> table(self::TABLES[$tab]) -> insert((array) $clone_row);

            if (!$this -> db -> transStatus()) {
                $error     = $this -> db -> error();  // Get the error details
                $errorCode = $error['code'];

                if ($errorCode === 1062) {
                    $errorMessage = "Това име {$data['oferName']} вече съществува. Въведете друго име за клонирането.";
                } else {
                    $errorMessage = $error['message'];
                }
                $this -> db -> transRollback();
                return ['err' => $errorMessage];
            }
            $this -> db -> transComplete();
            return true;
        } catch (DatabaseException $e) {
            $this -> db -> transRollback();
            return $e -> getMessage();
        }
    }

    // клониране на поръчка дилърска от сайт 
    // =======================================
    function clone_order($userName = '', $orderId = '') {

        if (!$orderId) {
            return []; // Return empty array or default data when tab is not provided
        }

        $clone_row = $this -> db -> table(self::TBL_ORDER)
                        -> where('order_id', $orderId)
                        -> get() -> getRowArray();

        // Unset unnecessary fields
        $fieldsToUnset = ['order_id', 'sp_status_id', 'tavaritelniza_no', 'tovaritelniza_key', 'date_shipping', 'gensoftOrder_json', 'userName_modify', 'date_added', 'date_update', 'is_open', 'locked_by'];
        foreach ($fieldsToUnset as $field) {
            unset($clone_row[$field]);
        }

        // Премахване на "inGensoftOrd" от product_json
        if ($_ENV['app.gensoftEnable'] && !empty($clone_row['product_json'])) {
            $products = json_decode($clone_row['product_json'], true);

            if (is_array($products)) {
                foreach ($products as &$product) {
                    unset($product['inGensoftOrd'],$product['gensoftSmetka'],$product['inGensoftSklad']);
                }

                $clone_row['product_json'] = json_encode($products, JSON_UNESCAPED_UNICODE);
            }
        }

        $clone_row['userName_create'] = $userName;

        try {
            $this -> db -> transBegin();

            $this -> db -> table(self::TBL_ORDER) -> insert($clone_row);

            if (!$this -> db -> transComplete()) { // Commit or rollback automatically
                $errorMessage = $this -> db -> error()['message'];
                return ['err' => $errorMessage];
            }
        } catch (DatabaseException $e) {
            $this -> db -> transRollback();
            return $e -> getMessage();
        }
    }

    // връщане на поръчка
    // ============================
    function return_order($data = []) {
        $this -> db -> transBegin();

        $builder = $this -> db -> table(self::TBL_ORDER);
        $clone   = $builder -> where('order_id', $data['orderId'])
                        -> get() -> getRowArray();

        $newProductData = [
            'order_id'     => $clone['order_id'],
            'klient_id'    => $clone['klient_id'],
            'product_json' => $clone['product_json'],
        ];

        // връщаме колич. което е поръчано 
        $jsonProduct = json_decode($clone['product_json'], true);
        foreach ($jsonProduct as $k => &$v) {
            $this -> db -> table(self::TBL_PRODUCT)
                    -> set('nalichnost', "nalichnost + {$v['qty']}", false)
                    -> where('product_id', $k)
                    -> where('gensoft_item_id is null')
                    -> update();
        }

        $builder -> set('sp_status_id', 5)
                -> where('order_id', $data['orderId'])
                -> update();

        $this -> db -> table(self::TBL_ORDERRETURN) -> upsert($newProductData);

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => $this -> db -> error()['message']];
        }
    }

    // връщане на поръчка
    // ============================
    function completeOrder($data = []) {
        $this -> db -> transBegin();

        $this -> db -> table(self::TBL_ORDER)
                -> set('sp_status_id', 4)
                -> where('order_id', $data['orderId'])
                -> update();

        if (!$this -> db -> transComplete()) { // Commit or rollback automatically
            return ['err' => $this -> db -> error()['message']];
        }
    }

    // Изтриване на поръчка от ел магазин
    // ==================================
    function delete_order($data = []) {
        $table = match ($data['orderTip']) {
            'site', 'L', 'K', 'F' => self::TBL_ORDER,
            'N' => self::TBL_ORDERCART,
            default => null,
        };

        $this -> db -> table($table)
                -> where('order_id', $data['orderId'])
                -> delete();
    }

    // обединяване на поръчки по id
    function unionOrders($orderIds = []) {
        $mergedProducts = [];

        $orders = $this -> db -> table(self::TBL_ORDER)
                        -> whereIn('order_id', $orderIds)
                        -> get() -> getResultArray();

        if (empty($orders)) {
            throw new Exception("No orders found for the given IDs.");
        }

        $mergedOrder = [
            'order_id'     => null,
            'sp_status_id' => 1,
            'klient_id'    => $orders[0]['klient_id'], // Example: assuming orders belong to the same customer
            'total_price'  => 0,
            'date_added'   => date('Y-m-d H:i:s'), // Use current timestamp for the new order
        ];

        foreach ($orders as $order) {

            $mergedOrder = array_merge($mergedOrder, array_diff_key($order, $mergedOrder));

            $mergedOrder['total_price'] += $order['total_price'];
            $decodedProduct_json        = json_decode($order['product_json'], true);

            foreach ($decodedProduct_json as $key => $value) {
                if (isset($mergedProducts[$key])) {
                    $mergedProducts[$key]['qty'] += $value['qty'];
                } else {
                    $mergedProducts[$key] = $value;
                }
            }
        }

        $mergedOrder['product_json'] = json_encode($mergedProducts, JSON_UNESCAPED_UNICODE);

        $newOrderId = $this -> db -> table(self::TBL_ORDER) -> insert($mergedOrder);

        if (!$newOrderId) {
            throw new Exception("Failed to create merged order.");
        }

        // Step 4: Delete original orders
        $this -> db -> table(self::TBL_ORDER)
                -> whereIn('order_id', $orderIds)
                -> delete();
    }

    function save_tovaritelnizaNo($urlParams = []) {
        $table = in_array($urlParams['orderTip'], ['site', 'L', 'K']) ? self::TBL_ORDER : self::TBL_ORDER_GENSOFT;

        if (!empty($urlParams['klient_id'])) {
            $get_key = $this -> db -> table($table)
                            -> select('tovaritelniza_key')
                            -> where('klient_id', $urlParams['klient_id'])
                            -> where('tavaritelniza_no', $urlParams['tavaritelniza_no'])
                            -> get() -> getRow();

            if (empty($get_key -> tovaritelniza_key)) {
                return ['notExist' => "Въведената товарителница {$urlParams['tavaritelniza_no']} не отговаря на съществуващата за избрания клиент"];
            }
        }

        $this -> db -> table($table)
                -> set('tavaritelniza_no', $urlParams['tavaritelniza_no'])
                -> set('tovaritelniza_key', $get_key -> tovaritelniza_key ?? NULL)
                -> where('order_id', $urlParams['order_id'])
                -> update();

        return ['status' => $this -> db -> affectedRows() > 0];
    }

    // извл. на всички записи за доставчици с групата и коментар към тях
    // ==================================================================
//    function get_provider() {
//        $providerGroup = $this -> db -> table('_provider_group')
//                        -> select('*')
//                        -> orderBy('provider_group_name', 'ASC')
//                        -> get() -> getResultArray();
//
//        $provider = $this -> db -> table('_provider')
//                        -> select('*')
//                        -> get() -> getResultArray();
//
//        return ['providerGroup' => $providerGroup, 'provider' => $provider];
//    }
//    // редакция на прикачн файл
//    // =========================
//    function ajax_update_attachFile_name_action($id, $sql_Table, $data = []) {
//        $ext    = '';
//        $folder = FCPATH . 'assets/_attachFile/' . $sql_Table . '/';
//
//        if ($data['fileName'] !== '') {
//            $row = $this -> db -> table($sql_Table) -> select('product_id') -> where('id', $id) -> get() -> getRowArray();
//
//            if (file_exists(FCPATH . $row['product_id'])) {
//                $ext     = $data['file'] ? $data['file'] -> getExtension() : pathinfo($row['product_id'], PATHINFO_EXTENSION);
//                $newName = strtolower(preg_replace('/[\s]+/', '_', urldecode($data['fileName']) . '.' . $ext));
//
//                $this -> db -> table($sql_Table)
//                        -> set('offersName', urldecode($data['fileName']))
//                        -> set('product_id', 'assets/_attachFile/' . $sql_Table . '/' . $newName)
//                        -> set('userName_modify', $data['userName_modify'])
//                        -> set('date_update', $data['date_update'])
//                        -> where('id', $id) -> update();
//
//                if ($data['file']) {
//                    unlink(FCPATH . $row['product_id']);
//                    $data['file'] -> move($folder, $newName);
//                } else {
//                    //преименуване на файла
//                    rename(FCPATH . $row['product_id'], $folder . $newName);
//                }
//            }
//        }
//    }
//
//    // проверка дали офертата се използва
//    // ===================================
//    function ajax_checkeLockStage($sqlTable, $id) {
//        return $this -> db -> table($sqlTable) -> select('lockRowState') -> where('id', $id) -> get() -> getRowObject();
//    }
//
//    // ########################################################################
//    // | ------------------------ PDF  ---------------------------------------|
//    // ########################################################################
//    // upload на pdf файл
//    // ==================
//    function ajax_upload_pdf($sqlTable, $data = []) {
//        $this -> db -> table($sqlTable) -> insert($data);
//    }
//
//    // ########################################################################
//    // | ------------------------ favorites  ---------------------------------|
//    // ########################################################################
//    // извличане на favorites за конкретен user
//    // ==========================================
//    function get_favorites($userID) {
//        return $this -> db -> table('_favorites') -> select('*') -> where('userID', $userID) -> get() -> getResultArray();
//    }
//
//    // запис на favorites за конкретен user
//    // =====================================
//    function ajax_save_favorites($data = []) {
//        $this -> db -> table('_favorites') -> insert($data);
//
//        return $this -> db -> insertID();
//    }
//
//    // обновяване на favorites за конкретен user
//    // =====================================
//    function ajax_update_favorites($id, $data = []) {
//        echo $this -> db -> table('_favorites') -> update($data, 'id=' . $id);
//    }
//
//    // изтриване на favorites за конкретен user
//    // =========================================
//    function ajax_delete_favorites($id) {
//        $this -> db -> table('_favorites') -> where('id', $id) -> delete();
//    }
}
