<?php

namespace App\Models\common;

use CodeIgniter\Model;
use \App\Models\BaseModel as BaseModel;

class MODEL__global extends BaseModel {

    // брой поръчки от сайт
    // ==================================
    function get__product_byId($productId = null) {

        $o = $this -> db -> table(self::TBL_PRODUCT)
                        -> select('product_id, product_name, gensoft_productName')
                        -> where('product_id', $productId)
                        -> get() -> getRowArray();

        return $o;
    }

    // брой поръчки от сайт
    // ==================================
    function get__orders_count_notification() {

        $o = $this -> db -> table(self::TBL_ORDER)
                -> select('order_id')
                -> where('sp_status_id', 1) // 1 - статус нова
                -> groupStart()
                -> where('orderTip <>', 'N')
                -> orWhere('orderTip IS NULL')
                -> groupEnd()
                // -> where('CAST( date_added AS DATE) =  CURRENT_DATE')
                -> countAllResults();

        return (int) $o;
    }

    // брой поръчки други от сайт(бърза, незавършени , клиентски)
    function get__orders_else_count_notification() {

        $orderCounts = $this -> db -> table(self::TBL_ORDER)
                        -> select('
        SUM(CASE WHEN orderTip = "L" AND sp_status_id = 1 THEN 1 ELSE 0 END) AS localOrder,
        SUM(CASE WHEN orderTip = "F" THEN 1 ELSE 0 END) AS fasttOrder,
        SUM(CASE WHEN orderTip = "K" AND sp_status_id = 1 THEN 1 ELSE 0 END) AS klietOrder,
        SUM(CASE WHEN orderTip IS NULL AND sp_status_id = 1 THEN 1 ELSE 0 END) AS dilarOrder
    ') -> get() -> getRowArray();

        $orderUncompleteCounts = $this -> db -> table(self::TBL_ORDERCART)
                        -> select('SUM(CASE WHEN orderTip = "N" THEN 1 ELSE 0 END) AS uncompleteOrder')
                        -> get() -> getRowArray();

        $arr = [
            'localOrder'      => (int) $orderCounts['localOrder'],
            'fasttOrder'      => (int) $orderCounts['fasttOrder'],
            'uncompleteOrder' => (int) $orderUncompleteCounts['uncompleteOrder'],
            'klietOrder'      => (int) $orderCounts['klietOrder'],
            'dilarOrder'      => (int) $orderCounts['dilarOrder']
        ];

        return $arr;
    }

    // запис на бр. показани записи в mainPage
    function set__userPreferences($data = []) {
        $this -> db -> table(self::TBL_USERPREF) -> upsert($data);
    }

    public function get__userPreferences($userId = '') {
        return $this -> db -> table(self::TBL_USERPREF)
                        -> where('user_id', $userId)
                        // -> where('modul_name', $modulName)
                        -> get() -> getResultArray();
    }

    public function get__users($data = []) {
        $r = $this -> db -> table(self::TBL_USERS)
                        -> select($data)
                        -> get() -> getResultArray();

        return $r;
    }

    public function get__sites() {
        $r = $this -> db -> table(self::TBL_SP_SITE)
                        -> get() -> getResultArray();

        return $r;
    }

    // брояч на задачите за текущия ден
    public function get__count_events() {
        $r = $this -> db -> table(self::TBL_EVENTS)
                        -> select('events_json')
                        -> where('events_date', date('d-m-Y'))
                        -> get() -> getRow();

        return $r;
    }

    // изв на всички ценови листи като име
    public function get__zenovaLista() {
        return $this -> db -> table(self::TBL_ZENOVA_LISTA)
                        -> select('id,offersName')
                        -> where('is_file is NULL')
                        -> get() -> getResultArray();
    }

    public function get__zenovaLista_byId($id = null) {

        return $this -> db -> table(self::TBL_ZENOVA_LISTA)
                        -> where('id', $id)
                        -> get() -> getRow();
    }

    //избиране на ценово ниво за всички продукти в таблицта
    function get__izbor_zenovoNivo($data = null) {

        $sql = $this -> db -> table(self::TABLES[$data['constTBL']] . ' o,' . self::TBL_PRODUCT . ' p')
                        -> select("*,{$data['nivo']} as nivo")
                        -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' zl', 'product_id', 'left')
                        -> where('o.id', $data['oferId'])
                        -> whereIn('p.product_id', $data['productIdArr'] ?? [0])
                        -> orderBy('FIND_IN_SET(p.product_id, o.productsID)')
                        -> get() -> getResultArray();

        return $sql;
    }

    // добавяне на избраната ценова листа към оферта
    function get__izbor_zenovaLista($data = null) {

        $sql = $this -> db -> table(self::TBL_ZENOVA_LISTA . ' o,' . self::TBL_PRODUCT . ' p')
                        -> select("*,{$data['nivo']} as nivo")
                        -> join(self::TBL_PRODUCT_PRICE_LEVEL . ' zl', 'product_id', 'left')
                        -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left')
                        -> join(self::TBL_BRAND . ' b', 'brand_id', 'left')
                        -> where('o.id', $data['zenovaLista_id'])
                        -> where('FIND_IN_SET(p.product_id,o.productsID)>0')
                        -> whereNotIn('p.product_id', $data['productIdArr'] ?? [0])
                        -> orderBy('FIND_IN_SET(p.product_id,o.productsID)')
                        -> get() -> getResultArray();
        return $sql;
    }

    public function get__mqrka() {
        return $this -> db -> table(self::TBL_SP_MQRKA)
                        -> get() -> getResultArray();
    }

//    public function get__razmer() {
//        return $this -> db -> table(self::TBL_SP_RAZMER)
//                        -> get() -> getResultArray();
//    }
//    public function get__teglo() {
//        return $this -> db -> table(self::TBL_SP_TEGLO)
//                        -> get() -> getResultArray();
//    }

    public function get__shablons($id = null) {

        $query = $this -> db -> table(self::TBL_SHABLON);

        if ($id) {
            return $query -> where('shablon_id', $id)
                            -> get() -> getRow();
        }

        return $query -> get() -> getResultArray();
    }

    //бр на всички продукти 
    function count__all_product($categoryId = null, $col = '', $searchName = null) {

        $sql = $this -> db -> table(self::TBL_PRODUCT . ' p')
                -> select('p.product_id,p.model_id,pm.*')
                -> join('(SELECT model_id,model FROM ' . self::TBL_MODEL . ' ) as pm', 'pm.model_id=p.model_id', 'left');

        if ($categoryId) {
            $sql -> where('p.category_id', $categoryId);
        }

        if ($searchName) {
            $sql -> like($col, $searchName, 'both');
        }


        return $sql -> countAllResults();
    }

    //извличане на езиците за оферта
    function get__languages() {

        return $this -> db -> table(self::TBL_SP_LANGUAGE)
                        -> orderBy('language_id', 'ASC')
                        -> get() -> getResultArray();
    }

    //извличане на валутите
    function get__valuta() {

        return $this -> db -> table(self::TBL_VALUTA)
                        -> orderBy('valuta_id', 'ASC')
                        -> get() -> getResultArray();
    }

    //обновяване на валута
    function save__valuta($valuta_id = '', $valuta_val = '') {

        $this -> db -> table(self::TBL_VALUTA)
                -> set('valuta_val', $valuta_val)
                -> where('valuta_id', $valuta_id)
                -> update();
    }

    // обновяване на стикера нов или очакван за избрани продукти
    function save__badge($productIds = [], $index = null) {

        $this -> db -> table(self::TBL_PRODUCT)
                -> set('badge_index', $index)
                -> whereIn('product_id', $productIds)
                -> update();
    }

    //извличане на статусите на офертите
    function get__status() {

        return $this -> db -> table(self::TBL_SP_STATUS)
                        -> get() -> getResultArray();
    }

    //извличане на категориите
    function get__kontragents($tip = null) {
        $query = $this -> db -> table(self::TBL_SP_KONTRAGENT);

        if ($tip) {
            $query -> where('tip', $tip);
        }

        return $query -> get() -> getResultArray();
    }

    public function get__all_categories() {
        return $this -> db -> table(self::TBL_CATEGORY)
                        -> orderBy('ISNULL(category_position)')
                        -> orderBy('category_position', 'ASC')
                        -> get() -> getResultArray();
    }

    public function get__totalProductCouut() {
        return $this -> db -> table(self::TBL_PRODUCT)
                        -> select('product_id')     // казваме му да ползва само PK
                        -> countAllResults();
    }

    //извличане на категориите
    function get__all_category($parent) {
        return $this -> db -> table(self::TBL_CATEGORY)
                        -> where($parent, null)
                        -> get() -> getResultArray();
    }

    //извличане на атрибутите на категориите
    function get__all_categoryAttributes($data = []) {
//        $r = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE . ' p')
//                        -> select([
//                            'p.is_visible',
//                            'p.is_visible_inCatalog',
//                            'p.category_id',
//                            'p.category_characteristic_id',
//                            'p.value as category_characteristic_value'
//                        ])
//                        -> whereIn('p.category_id', array_column($data, 'category_id'))
//                        -> orderBy('ISNULL(category_char_position)')
//                        -> orderBy('category_char_position', 'ASC')
//                        -> get() -> getResultArray();
//        $r = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE . ' p')
//                        -> select('c.product_id,p.is_visible_inCatalog,c.product_characteristic_id,p.category_characteristic_id,p.value as category_characteristic_value,p.category_char_position,pav.*')
//                        -> join(self::TBL_PRODUCT_CHARACTERISTIC . ' c', 'category_characteristic_id', 'left')
//                        -> join(self::TBL_PRODUCT_CHAR_VALUE . ' pav', 'product_characteristic_value_id', 'left')
//                        // -> whereIn('p.category_id', array_column($data, 'category_id'))
//                        -> whereIn('c.product_id', array_column($data, 'product_id'))
//                        -> orderBy('ISNULL(p.category_char_position)')
//                        -> orderBy('p.category_char_position', 'ASC')
//                        -> get() -> getResultArray();
        //dd($r);
        if (empty($data)) {
            return [];
        }

        $r2 = $this -> db -> table(self::TBL_CATEGORY_ATTRIBUTE . ' ca')
                        -> select([
                            'ca.is_visible',
                            'ca.is_visible_inCatalog',
                            'ca.category_id',
                            'ca.category_characteristic_id',
                            'ca.value as category_characteristic_value',
                            'pc.product_id',
                            'pc.product_characteristic_id',
                            'pcv.*'
                        ])
                        -> join(self::TBL_PRODUCT_CHARACTERISTIC . ' pc', 'category_characteristic_id', 'inner')
                        -> join(self::TBL_PRODUCT_CHAR_VALUE . ' pcv', 'product_characteristic_value_id', 'left')
                        -> where('ca.is_visible_inCatalog', 1)
                        -> whereIn('ca.category_id', array_column($data, 'category_id'))
                        -> whereIn('pc.product_id', array_column($data, 'product_id'))
                        //-> groupBy('category_characteristic_id')
                        -> orderBy('ISNULL(ca.category_char_position)', 'ASC')
                        -> orderBy('ca.category_char_position', 'ASC')
                        -> get() -> getResultArray();

        //dd($r2);
        return $r2;
    }

    function autocomplete($input_name = '', $input_value = '') {

        return $this -> db -> table(self::TBL_AUTO_COMPLETE)
                        -> like('auto_name', $input_value, 'both')
                        -> where($input_name, 1)
                        -> get() -> getResultArray();
    }

}
