<?php

namespace App\Models;

use CodeIgniter\Model;
use \App\Models\BaseModel as BaseModel;

class MODEL__fileManager extends BaseModel {

    public function __construct() {
        parent::__construct();
    }

    // качване на файл като оферта или цен листа
    function upload_file($data = [], $arg = '') {

        if (!$arg || !array_key_exists($arg, self::TABLES)) {
            return []; // Return empty array or default data when tab is not provided
        }

        // Check for duplicate offersName
        $existingOffer = $this -> db -> table(self::TABLES[$arg])
                        -> select('id')
                        -> where('offersName', $data['offersName'])
                        -> get() -> getRow();

        if ($existingOffer) {
            return ['err' => "Това име {$data['offersName']} вече съществува. Въведете друго име."];
        }

        // ако редактираме файла като име
        if (isset($data['id']) && !empty($data['id'])) {
            $this -> db -> table(self::TABLES[$arg])
                    -> set($data)
                    -> where('id', $data['id'])
                    -> update();
        } else {
            // ако файлът е качен    
            $this -> db -> table(self::TABLES[$arg]) -> insert($data);
            $last_id = $this -> db -> insertID();

            $this -> db -> table(self::TABLES[$arg])
                    -> set('file_dir', $arg . '/' . $last_id . '/' . $data['file_dir'])
                    -> where('id', $last_id)
                    -> update();
        }

        return empty($last_id) ? $data['id'] : $last_id;
    }

    function delete_file($id = '', $arg = '', $is_ofer = false) {

        if ($is_ofer) {
            $this -> db -> table(self::TABLES[$arg]) -> where('id', $id) -> update(['file_dir' => null]);
        } else {
            $this -> db -> table(self::TABLES[$arg]) -> where('id', $id) -> delete();
        }
    }

}
