<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Exceptions\DatabaseException;
use CodeIgniter\Database\BaseBuilder;
use CodeIgniter\Database\BaseConnection;

class BaseModel extends Model {

    protected const LOCALSITE                      = 3;
    ///////////////////////////////////////////////
    protected const TABLES                         = [
        'zenova'    => self::TBL_ZENOVA_LISTA,
        'promo'     => self::TBL_PROMO,
        'baner'     => self::TBL_BANER,
        'bizKlient' => self::TBL_BIZNESKLIENT,
        'special'   => self::TBL_SPECIAL,
        'order'     => self::TBL_ORDER,
        'dostavka'  => self::TBL_DOSTAVKA,
        'spProduct' => self::TBL_PRODUCT,
    ];
    protected const TABLES2                        = [
        'k'  => self::TBL_KLIENT,
        'st' => self::TBL_STATUS,
    ];
    public const TBL_CRONJOBS                   = 'cron_jobs';
    public const TBL_BRAND                      = '_brand';
    public const TBL_MODEL                      = '_model';
    public const TBL_PRODUCT_MODEL_ADDIT_LINK   = '_product_modelAddit_link';
    protected const TBL_MODEL_PROPERTY             = '_model_property';
    /////////////////////////////////////////////////////////////////////////
    public const TBL_PRODUCT                    = '_product';
    protected const TBL_PRODUCT_PRICE_LEVEL        = '_product_priceLevel';
    protected const TBL_PRODUCT_PRICE_LEVEL_BACKUP = '_product_priceLevel_multi_backup';
    protected const TBL_PRODUCT_IN_ZENOVALISTA     = '_product_in_zenovaLista';
    protected const TBL_PRODUCT_IN_PROMOLISTA      = '_product_in_promoLista';
    protected const TBL_PRODUCT_IN_PROMOKL         = '_product_in_promoKl';
    protected const TBL_PRODUCT_CHAR_VALUE         = '_product_characteristic_value';
    protected const TBL_PRODUCT_CHARACTERISTIC     = '_product_characteristic';
    protected const TBL_PRODUCT_SITES              = '_product_sites';
    /////////////////////////////////////////////////////////////////////////////
    public const TBL_CATEGORY                   = '_category';
    protected const TBL_CATEGORY_ATTRIBUTE         = '_category_characteristic';
    public const TBL_CATEGORY_GENSOFT           = '_category_gensoft';
    //////////////////////////////////////////////////////////////////////////////////////
    protected const TBL_EVENTS                     = '_events';
    protected const TBL_DOSTAVKA                   = '_dostavka';
    public const TBL_ZENOVA_LISTA               = '_ofer_zenovaLista';
    protected const TBL_ORDERRETURN                = '_order_return';
    protected const TBL_ORDERCART                  = '_order_cart';
    protected const TBL_ORDER                      = '_order';
    protected const TBL_ORDER_GENSOFT              = '_order_gensoft';
    // protected const TBL_ORDERLOCAL             = '_order_local';
    // protected const TBL_ORDERDETAIL            = '_order_detail';
    protected const TBL_SPECIAL                    = '_ofer_special';
    protected const TBL_PROMO                      = '_ofer_promo';
    protected const TBL_PROMOKL                    = '_ofer_promoKl';
    protected const TBL_BIZNESKLIENT               = '_ofer_biznesKlient';
    protected const TBL_BANER                      = '_ofer_baner';
    ///////////////////////////////////////////////////////////////////////////////
    protected const TBL_SP_SITE                    = '_sp_site';
    protected const TBL_SP_MQRKA                   = '_sp_mqrka';
    protected const TBL_SP_STATUS                  = '_sp_status';
    protected const TBL_SP_COUNTRY                 = '_sp_country';
    protected const TBL_SP_KONTRAGENT              = '_sp_kontragent';
    protected const TBL_SP_RAZMER                  = '_sp_razmer';
    protected const TBL_SP_TEGLO                   = '_sp_teglo';
    protected const TBL_SP_LANGUAGE                = '_sp_language';
    protected const TBL_STATUS                     = '_sp_status';
    ////////////////////////////////////////////////////////////////////////////////
    protected const TBL_VALUTA                     = '_valuta';
    protected const TBL_SHABLON                    = '_shablon';
    protected const TBL_KLIENT                     = '_klient';
    protected const TBL_AUTO_COMPLETE              = '_autoComplete';
    protected const TBL_PROVIDER                   = '_provider';
    protected const TBL_PROVIDER_GROUP             = '_provider_group';
    protected const TBL_PROVIDER_INGROUP           = '_provider_inGroup';
    ////////////////////////////////////////////////////////////////
    protected const TBL_NASHIFIRMI                 = '_nashiFirmi';
    protected const TBL_USERS                      = 'users';
    protected const TBL_USERSITE                   = 'users_site';
    /////////////////////////////////////
    protected const TBL_SETINGS_PORTAL             = 'settings_portal';
    protected const TBL_USERPREF                   = 'user_preferences';

    /** Унифициран репорт за DB грешки */
    protected function dbError($msg = null, string $fallbackMsg = 'Грешка при изпълнение на sql заявка!') {
        $err        = $this -> db -> error();
        $code       = $err['code'] ?? 0;
        $sqlMessage = $err['message'] ?? '';

        // Определи съобщението
        $finalMessage = match (true) {
            !empty($msg) && $code == 0 => $msg,
            // $code === 1062 => 'Запис с такива данни вече съществува.',
            $code === 1062 && preg_match("/Duplicate entry '(.+?)'/", $sqlMessage, $m)
            => "Стойността '$m[1]' $msg вече съществува.",
            default => $fallbackMsg . ' ' . $sqlMessage
        };

        return ['err' => $finalMessage];
    }

    /**
     * Добавя към $builder->select() всички колони БЕЗ префикс.
     * - За алиасите в 'only' взема само изброените колони; за останалите – всички.
     * - При колизии: 'skip' (default) пази първото име; 'suffix' => col_2, col_3 ...
     * Опции:
     *   - only            : ['alias' => ['col1','col2']]
     *   - skip            : ['alias' => ['colX','colY']]
     *   - include_aliases : ['p','m', ...]        // ограничи до тези алиаси (по избор)
     *   - skip_types      : ['blob','json', ...]  // по избор
     *   - on_conflict     : 'skip'|'suffix'       // default 'skip'
     *   - rename          : ['alias' => ['oldCol' => 'newCol']]
     *   - extra           : ['SQL_EXPR AS `name`', ...]
     */
    protected array $schemaCache = []; // [$dbName][$table] => [['col'=>'...', 'type'=>'...'], ...]

    protected function selectCols(BaseBuilder $b, array $opt = []): void {
        $only            = $opt['only'] ?? [];
        $skip            = $opt['skip'] ?? [];
        $exclude_aliases = $opt['exclude_aliases'] ?? [];
        $extra           = (array) ($opt['extra'] ?? []);
        $debug           = (bool) ($opt['debug'] ?? false);     // <- само за дебъг
        $prefixDelim     = (string) ($opt['prefix_delim'] ?? '__');    // <- по избор

        $aliases = $this -> aliasMap($b);
        if (!$aliases)
            return;

        // schema cache и списък колони по алиаси
        $colsByAlias = [];
        foreach ($aliases as $a => $t) {
            $colsByAlias[$a] = $only[$a] ?? $this -> tableCols($this -> normalizeTableName($t));

            if (isset($exclude_aliases)) {
                foreach ($exclude_aliases as $ex) {
                    unset($colsByAlias[$ex]);
                }
            }

            if (!empty($skip[$a])) {
                $colsByAlias[$a] = array_values(array_diff($colsByAlias[$a], (array) $skip[$a]));
            }
        }

        $used  = [];   // изходни имена => true
        $parts = [];

        foreach ($colsByAlias as $a => $cols) {
            $aSafe = $this -> sanitizeIdent($a);

            foreach ($cols as $k => $v) {
                $src = null;
                $out = null;

                if (is_int($k)) {
                    // Поддържа: "col", "col alias", "col AS alias"
                    $spec = trim((string) $v);
                    if (preg_match('/^([`"\[\]A-Za-z0-9_]+)\s+(?:AS\s+)?([`"\[\]A-Za-z0-9_]+)$/i', $spec, $m)) {
                        $src = $this -> sanitizeIdent($this -> cleanIdent($m[1]));
                        $out = $this -> sanitizeIdent($this -> cleanIdent($m[2]));
                    } else {
                        $src = $this -> sanitizeIdent($this -> cleanIdent($spec));
                    }
                } else {
                    // Асоциативно: 'col' => 'alias'
                    $src = $this -> sanitizeIdent($this -> cleanIdent((string) $k));
                    $out = $this -> sanitizeIdent($this -> cleanIdent((string) $v));
                }

                if ($src === '')
                    continue;

                // ако няма зададен alias – ползвай default (debug префикс или името на колоната)
                if ($out === null || $out === '') {
                    $out = !empty($opt['debug']) ? ($aSafe . '__' . $src) : $src;
                }

                // skip при колизия
                if (isset($used[$out]))
                    continue;
                $used[$out] = true;

                $parts[] = "`{$aSafe}`.`{$src}` AS `{$out}`";
            }
        }


        foreach ($extra as $e) {
            if (is_string($e) && $e !== '')
                $parts[] = $e;
        }

        if ($parts)
            $b -> select(implode(', ', $parts), false);

        if ($debug) {
            dd($b -> get() -> getResultArray());
        }
    }

    /* ---------- помощни (кратки) ---------- */

    protected function aliasMap(BaseBuilder $b): array {
        $sql = (string) $b -> getCompiledSelect(false);
        if ($sql === '')
            return [];
        $s   = preg_replace('/\s+/u', ' ', $sql);
        $pat = '/\b(?:FROM|JOIN)\s+([`"\[\]\w\.]+)\s+(?:AS\s+)?([`"\[\]\w]+)/i';
        $out = [];
        if (preg_match_all($pat, $s, $m, PREG_SET_ORDER)) {
            foreach ($m as $r) {
                $t       = $this -> cleanIdent($r[1]);
                $a       = $this -> cleanIdent($r[2]);
                if ($t === '' || $a === '' || $t[0] === '(')
                    continue;
                $out[$a] = $t;
            }
        }
        return $out;
    }

    protected function tableCols(string $table): array {
        $db     = $this -> db;
        $dbName = $db -> getDatabase();
        if ($table === '')
            return [];
        if (!isset($this -> schemaCache[$dbName][$table])) {
            $rows                                 = $db -> query("SHOW COLUMNS FROM `{$table}`") -> getResultArray();
            $this -> schemaCache[$dbName][$table] = array_map(static fn($r) => $r['Field'], $rows);
        }
        return $this -> schemaCache[$dbName][$table];
    }

    protected function normalizeTableName(string $name): string {
        $id  = $this -> cleanIdent($name);
        if (($dot = strrpos($id, '.')) !== false)
            $id  = substr($id, $dot + 1);
        if (($sp  = strpos($id, ' ')) !== false)
            $id  = substr($id, 0, $sp);
        return $id;
    }

    protected function cleanIdent(string $id): string {
        return trim($id, " \t\n\r\0\x0B`[]\"'");
    }

    protected function sanitizeIdent(string $id): string {
        $out = preg_replace('~[^A-Za-z0-9_]+~', '_', $id);
        return ltrim($out, '_');
    }

}
