<?php

namespace App\Libraries;

class Pagination_ajax {

    // генериране на номериране на страници
    public function generate($data = []) {

        $li          = '';
        $page        = (int) $data['page'];
        $total_pages = (int) $data['total_pages'];

        $visiblePages = 10;               // колко номера показваме
        $half         = floor($visiblePages / 2);

        /* ------------------------------------------------------------
          | PREV
         * ------------------------------------------------------------ */
        if ($page > 1) {
            $li .= $this -> generateListItem(
                    'prev',
                    '&#10094; ' . lang('LANG__pagnitation.prev'),
                    'class="next p-0 page-link"',
                    null,
                    $data
            );
        }

        /* ------------------------------------------------------------
          | START / END RANGE
         * ------------------------------------------------------------ */
        $start = max(1, $page - $half);
        $end   = min($total_pages, $start + $visiblePages - 1);

// ако сме близо до края – избутваме назад
        $start = max(1, $end - $visiblePages + 1);

        /* ------------------------------------------------------------
          | FIRST + ...
         * ------------------------------------------------------------ */
        if ($start > 1) {
            $li .= $this -> generateListItem(1, '1', null, null, $data);
            $li .= $this -> generateListItem('', '...', 'class="pointer-events-none"', null, $data);
        }

        /* ------------------------------------------------------------
          | PAGE NUMBERS
         * ------------------------------------------------------------ */
        for ($i = $start; $i <= $end; $i++) {
            $li .= $this -> generateListItem(
                    $i,
                    $i,
                    ($i == $page) ? 'class="page-item pointer-events-none active"' : '',
                    null,
                    $data
            );
        }

        /* ------------------------------------------------------------
          | ... + LAST
         * ------------------------------------------------------------ */
        if ($end < $total_pages) {
            $li .= $this -> generateListItem('', '...', 'class="pointer-events-none"', null, $data);
            $li .= $this -> generateListItem($total_pages, $total_pages, null, null, $data);
        }

        /* ------------------------------------------------------------
          | NEXT
         * ------------------------------------------------------------ */
        if ($page < $total_pages) {
            $li .= $this -> generateListItem(
                    'next',
                    lang('LANG__pagnitation.next') . ' &#10095;',
                    'class="next p-0 page-link"',
                    null,
                    $data
            );
        }

        return $li;
    }

    private function generateListItem($page, $text, $class = '', $additionalAttributes = '', $data = []) {
        //dd($additionalAttributes);
        $arg = '  data-ctrl = "' . esc($data['ctrl']) . '" data-arg = "' . esc($data['arg']) . '"   ';

        return '<li ' . $class . ' data-page="' . $page . '" ' . $arg . ' data-route="' . $data['route'] . '" ' . $additionalAttributes . '><a class="page-link" href="javascript:;">' . $text . '</a></li>';
    }

}
