<?php

namespace App\Libraries;

class Pagination {

    // генериране на номериране на страници
    public function generate($data = []) {

        $page        = $data['page'];
        $total_pages = $data['total_pages'];
        $next        = lang('LANG__pagnitation.next');
        $prev        = lang('LANG__pagnitation.prev');

        $urlParams = [];
        $li        = '';
        $s         = '';

        if (!empty($_GET)) {
            $urlParams = $_GET;
            unset($urlParams['isRefresh']);
        }

        if ($page > 1) {
            $urlParams['page'] = ($page - 1) . $s;

            $li .= '<li><a class="page-link" href="?' . http_build_query($urlParams) . '">
                                    <span>&#10094; ' . $prev . '</span></a></li>';
        }

        if (($page - 2) > 1) {
            $urlParams['page'] = 1;

            $li .= '<li><a class="page-link" href="?' . http_build_query($urlParams) . '">1</a></li>
                    <li><a class="page-link">...</a></li>';
        }

        $index = $total_pages <= 10 ? 10 : 6;

        for ($i = ($page - 2); $i <= ($page + $index); $i++) {
            $dataPage = '';
            $disabled = '';
            $current  = '';

            if ($i < 1)
                continue;
            if ($i > $total_pages)
                break;
            if ($i == 1) {
                $dataPage = 'data-page = "1"';

                if (!empty($urlParams['tab'])) {
                    $urlParams['tab'] = 'zenova';
                }
            }
            if ($i == $page) {
                $disabled = 'pointer-events-none active';
                $current  = 'current';
            }

            $urlParams['page'] = $i . $s;

            $li .= '<li class="page-item ' . $disabled . '"' . $dataPage . '><a class="page-link ' . $current . '" href="?' . http_build_query($urlParams) . '">' . $i . '</a></li>';
        }

        if (($total_pages - ($page + 1)) >= 1 && $total_pages > 10) {
            $li .= '<li><a class="page-link">...</a></li>';
        }

        if (($total_pages - ($page + 1)) > 0 && $total_pages > 10) {
            $urlParams['page'] = $total_pages . $s;

            $li .= '<li class="page-item"><a class="page-link" href="?' . http_build_query($urlParams) . '">' . $total_pages . '</a></li>';
        }


        if ($page < $total_pages) {
            $urlParams['page'] = ($page + 1) . $s;

            $li .= '<li><a class="page-link" href="?' . http_build_query($urlParams) . '"><span>' . $next . ' &#10095;</span></a></li>';
        }

        return $li;
    }

    public function generate2($data = []) {

        $li  = '';
        $s   = '';
        $tab = $data['tab'];
        $col = $data['col'] ?? ''; // ako търсим в много колони

        $perPage     = $data['perPage'];
        //$path        = $data['path'];
        $page        = $data['page'];
        $total_pages = $data['total_pages'];
        $searchName  = $data['searchName'];

        $next = lang('LANG__pagnitation.next');
        $prev = lang('LANG__pagnitation.prev');

        if ($searchName) {
            $s = ($col != null ? '&col=' . $col : '') . '&searchName=' . $searchName;
        }

        if ($page > 1) {
            $li .= '<li><a class="next page-link" href="?page=' . ($page - 1) . $s . '&perPage=' . $perPage . '">
                                    <span>&#10094; ' . $prev . '</span></a></li>';
        }

        if (($page - 2) > 1) {
            $li .= '<li><a class="page-link" href="?page=1&perPage=' . $perPage . '">1</a></li>
                    <li><a class="page-link">...</a></li>';
        }

        $index = $total_pages <= 10 ? 10 : 4;

        for ($i = ($page - 2); $i <= ($page + $index); $i++) {
            $dataPage = '';
            $class    = '';

            if ($i < 1)
                continue;
            if ($i > $total_pages)
                break;
            if ($i == 1) {
                $dataPage = 'data-page = "1"';
            }
            if ($i == $page) {
                $class = "class = 'page-item pointer-events-none active'";
            }

            $li .= '<li ' . $class . $dataPage . '><a class="page-link" href="?page=' . $i . $s . '&perPage=' . $perPage . '">' . $i . '</a></li>';
        }

        if (($total_pages - ($page + 1)) >= 1 && $total_pages > 10) {
            $li .= '<li><a class="page-link">...</a></li>';
        }

        if (($total_pages - ($page + 1)) > 0 && $total_pages > 10) {
            $li .= '<li><a class="page-link" href="?page=' . $total_pages . $s . '&perPage=' . $perPage . '">' . $total_pages . '</a></li>';
        }


        if ($page < $total_pages) {
            $li .= '<li><a class="next page-link" href="?page=' . ($page + 1) . $s . '&perPage=' . $perPage . '"><span>' . $next . ' &#10095;</span></a></li>';
        }

        return $li;
    }

}
