<?php

namespace App\Libraries;

use \App\Models\BaseModel;
use \App\Models\common\MODEL__global;

//use \App\Controllers\BaseController;

class LIB__CategoryTree extends \App\Controllers\BaseController {

    protected $settings;

    public function __construct() {
        parent::__construct();
        $this -> MODEL__global = new MODEL__global();
    }

    // основна функция 

    public function render($skladId = '') {

        $tree = $this -> buildCategoryTree(null, $this -> MODEL__global -> get__all_categories());

        $r = $this -> renderTree($tree, true);
        //  dd($r);
        return $r;
    }

    /**  Рендиране на списъка с групи ul
      ========================================== */
    protected function renderTree(array $tree, bool $isRoot = false): string {
        if (!$tree) {
            return '';
        }

        $imgGensoft = $_ENV['app.imageDataDir'] . 'logos/genSoft.jpg';
        $cssHtml    = '';
        $jsHtml     = '';
        $gB         = '';

        foreach ($this -> addCSS() as $css) {
            $cssHtml .= sprintf(
                    '<link rel="stylesheet" type="text/css" href="%s">',
                    auto('assets/' . $css . '.css')
            );
        }

        foreach ($this -> addJS() as $js) {
            $jsHtml .= sprintf(
                    '<script src="%s"></script>',
                    auto('assets/' . $js . '.js')
            );
        }

        $route_filter = route_to('Popup_izboProduct-refreshTable');
        $list         = '<ul' . ($isRoot ? ' class="root overflow-auto" style="max-height: calc(100vh - 250px);"' : '') . '>';

        foreach ($tree as $item) {

            $children    = $item['children'] ?? [];
            $hasChildren = !empty($children);
            $label       = $item['category_name'];
            $id          = $item['category_id'];
            $toggleStyle = $hasChildren ? '' : 'style="visibility:hidden"';
            $liClass     = $hasChildren ? 'has-children' : '';

            $list .= <<<HTML
                        <li class="$liClass">
                            <div class="js-node css-node" data-value="$label">
                                <span class="toggle" $toggleStyle></span>
                                <input type="checkbox" value="$id" data-root="$isRoot">
                                <span class="js-label css-label">$label</span>
                            </div>
                     HTML;

            if ($hasChildren) {
                $list .= $this -> renderTree($children);
            }

            $list .= '</li>';
        }

        $list .= '</ul>';

        //  Само ако е ROOT – добавяме search + actions
        if (!$isRoot) {
            return $list;
        }

        return <<<HTML
                    $cssHtml

                    <div class="mb-2">
                        <input id="treeSearchCat" class="css-input-p css-focus-strong css-border-none" type="text" placeholder="Търси по категория…">
                    </div>
        
                    <div id="renderTreeCat">$list</div>

                    <div class="actions mb-2 w-20 text-center row justify-content-center">
                        <button id="getSelectedCat" class="round-10 bg-primary" data-route="$route_filter" type="button">Филтрирай</button>
                        <button id="reset" class="round-10" data-route="$route_filter" type="button">Reset</button>
                    </div>

                    $jsHtml
                HTML;
    }

    public function addCSS() {
        return [
            'css/lib/gensoft/gensoftGroups'
        ];
    }

    public function addJS() {
        return [
            'js/lib/Lib__treeCore'
        ];
    }

}
