<?php

// app/Helpers/CustomHelper.php


use Config\Services;

if (!function_exists('generate_li')) {

    function generate_li($data = []) {

        $routeDelete   = route_to('MainPage_providers-delete_inGroup', $data['provider_id']);
        $routeEdit     = route_to('Provider-edit', $data['lastId']);
        $confirmDelete = lang('LANG__global.js.confirm.deleteOferta', [$data['provider_name']]);

        $li = <<<HTML
  <li class="m-1" data-providerid="{$data['lastId']}" data-groupid="{$data['provider_group_id']}">
                                <label class="providerName">{$data['provider_name']}</label>
         
                                <div class="btn-group btn-group-sm float-right">
                                
                                     <a class="btn-outline-secondary p-1 border-0 fa fa-comment" title="<?= lang('LANG__global.btn.edit') ?>" href="{$routeEdit}"></a>

                                      <a class="btn-outline-danger p-1 border-0 fa fa-trash" href="{$routeDelete}" title="<?= lang('LANG__global.btn.delete') ?>" onclick="javasciprt: return confirm('{$confirmDelete}')"></a>
                                </div>
                            </li>
HTML;

        return $li;
    }

}
    
