<?php

// app/Helpers/auto_helper.php
if (!function_exists('HELPER_defaultJsonNav')) {

    /** Навигация за Home Page и sidebar menu като PHP масив */
    // ако има променен файл се изчиства кеша
    function HELPER_defaultJsonNav() {

        return [
            'main'     => [
                'key'      => 'main',
                'title'    => 'Основни функции',
                'position' => 1,
                'visible'  => true,
                'items'    => [
                    [
                        // 'id'       => 'zenova',
                        'label'    => 'Ценови листи',
                        'icon'     => 'fa fa-tags',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabZenova'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'special',
                        'label'    => 'Оферти',
                        'icon'     => 'fa fa-file-text-o',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabSpecial'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'sys',
                        'label'    => 'Главно табло',
                        'icon'     => 'fa fa-area-chart',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => 'dashboard',
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'biz',
                        'label'    => 'Бизнес клиенти Оферти',
                        'icon'     => 'fa fa-briefcase',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabBizKlient'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'order',
                        'label'    => 'Поръчки',
                        'icon'     => 'fa fa-shopping-cart',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabOrder', 'orderTip=site'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        'id'       => 'promo',
                        'label'    => 'Промоции',
                        'icon'     => 'fa fa-bullhorn',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabPromo', 'promoTip=D'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'baner',
                        'label'    => 'Заявка за банер',
                        'icon'     => 'fa fa-picture-o',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('tabBaner'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'tasks',
                        'label'    => 'Задачи',
                        'icon'     => 'fa fa-tasks',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Events-index', 'raznos'),
                            'target' => '_blank'
                        ],
                    ],
                ],
            ],
            'lists'    => [
                'key'      => 'lists',
                'title'    => 'СПИСЪЦИ',
                'position' => 2,
                'visible'  => true,
                'items'    => [
                    [
                        'label'    => 'Категории',
                        'icon'     => 'fa fa-sitemap',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id'         => 'spCat',
                            'data-route' => route_to('POPup_category-open2')
                        ]
                    ],
                    [
                        //'id'       => 'products',
                        'label'    => 'Продукти',
                        'icon'     => 'fa fa-cubes',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Product__sp', 'tab=spProduct&page=1'),
                            'target' => '_blank'
                        ],
                    //'href'     => '/spisak/Product/index?tab=spProduct&page=1&perPage=100'
                    ],
                    [
                        //'id'       => 'clients',
                        'label'    => 'Клиенти',
                        'icon'     => 'fa fa-address-book',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Klient__sp', 'tab=klient&page=1'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        'label'    => 'Характеристики',
                        'icon'     => 'fa fa-list-alt',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id'         => 'spCatAttr',
                            'data-route' => route_to('POPup_categoryAttr-open')
                        ]
                    ],
                    [
                        // 'id'       => 'firms',
                        'label'    => 'Наши фирми',
                        'icon'     => 'fa fa-building',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('NashiFirmi_sp', 'page=1'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'templates',
                        'label'    => 'Шаблонни',
                        'icon'     => 'fa fa-clone',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id'         => 'openShablon',
                            'data-route' => route_to('POPup_shablon-open')
                        ]
                    ],
                    [
                        // 'id'       => 'units',
                        'label'    => 'Мерни единици',
                        'icon'     => 'fa fa-balance-scale',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id'         => 'openMqrka',
                            'data-route' => route_to('POPup_mqrka-open')
                        ]
                    ],
                ],
            ],
            'settings' => [
                'key'      => 'settings',
                'title'    => 'Настройки',
                'position' => 3,
                'visible'  => true,
                'items'    => [
                    [
                        // 'id'       => 'sys',
                        'label'    => 'НАСТРОЙКА НА СИСТЕМАТА',
                        'icon'     => 'fa fa-cog',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Nastrojka-set'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        //'id'       => 'portal',
                        'label'    => 'НАСТРОЙКА ПОРТАЛ',
                        'icon'     => 'fa fa-globe',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Nastrojka-portal') . '&link=slideshow',
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'firma',
                        'label'    => 'ДАННИ ЗА ФИРМАТА',
                        'icon'     => 'fa fa-address-card',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Nastrojka-firma'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'      => 'gensoft',
                        'label'   => 'НАСТРОЙКИ ГЕНСОФТ',
                        'icon'    => 'fa fa-cogs',
                        'visible' => true,
                        'attrs'   => [
                            'href'   => route_to('Nastrojka-gensoft'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'      => 'gensoft',
                        'label'   => 'НАСТРОЙКИ SEO',
                        'icon'    => 'fa fa-star-o',
                        'visible' => true,
                        'attrs'   => [
                            'href'   => route_to('Nastrojka-seo'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        //'id'       => 'files',
                        'label'    => 'МЕНИДЖЪР ДОКУМЕНТИ',
                        'icon'     => 'fa fa-file',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id' => 'fileManager'
                        ]
                    ],
                    [
                        // 'id'       => 'openExpImp',
                        'label'    => 'ИМПОРТ/ЕКСПОРТ ГЕНСОФТ БД',
                        'icon'     => 'fa fa-exchange',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'id'         => 'openExpImp',
                            'data-route' => route_to('POPup_expImp-open')
                        ]
                    ],
                    [
                        //'id'       => 'sql',
                        'label'    => 'SQL МЕНИДЖЪР',
                        'icon'     => 'fa fa-database',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'onclick' => 'window.open("/assets/plugins/_sql_Manager/index.php","SQL мениджър","width=800,height=700"); return false;']
                    ],
                    [
                        //'id'       => 'logs',
                        'label'    => 'ЛОГОВЕ ГРЕШКИ',
                        'icon'     => 'fa fa-bug',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('LogViewer'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        //'id'       => 'patch',
                        'label'    => 'ДОБАВЯНЕ PATCH (DEV)',
                        'icon'     => 'fa fa-code',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('PatchFile'),
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'translator',
                        'label'    => 'Преводач',
                        'icon'     => 'fa fa-language',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => 'https://my.gtranslate.io/login',
                            'target' => '_blank'
                        ],
                    ],
                    [
                        // 'id'       => 'users',
                        'label'    => 'Потребители',
                        'icon'     => 'fa fa-user-circle',
                        'visible'  => true,
                        'position' => 1,
                        'attrs'    => [
                            'href'   => route_to('Users_index'),
                            'target' => '_blank'
                        ],
                    ],
                ],
            ],
        ];
    }

}
