<?php
/*
  ТУК СЕ ПРОВЕРЯВА ДАЛИ СА НАЛИЦЕ
  КОЛОНИ, ИНДЕКСИ, ТРИГЕРИ, ГЕНЕРАТОРИ И ДОСТЪПНОСТ ДО СЪРВАРА НА GENSFOT
 */

/*
  Проверка дали съществува колона
 */
if (!function_exists('h_column_exists')) {

    function h_column_exists($conn, string $table, string $column): bool {
        $sql = "SELECT 1 FROM RDB\$RELATION_FIELDS WHERE RDB\$RELATION_NAME = ?
                    AND RDB\$FIELD_NAME = ?";

        $st = ibase_prepare($conn, $sql);
        $rs = ibase_execute($st, strtoupper($table), strtoupper($column));

        return (bool) ibase_fetch_row($rs);
    }

}

/**
 * Проверка за индекс
 */
if (!function_exists('h_index_exists')) {

    function h_index_exists($conn, string $index): bool {
        $sql = "SELECT 1 FROM RDB\$INDICES WHERE RDB\$INDEX_NAME = ?";
        $st  = ibase_prepare($conn, $sql);
        $rs  = ibase_execute($st, strtoupper($index));

        return (bool) ibase_fetch_row($rs);
    }

}

/**
 * Проверка за тригер
 */
if (!function_exists('h_trigger_exists')) {

    function h_trigger_exists($conn, string $name): bool {
        $sql = "SELECT 1 FROM RDB\$TRIGGERS WHERE RDB\$TRIGGER_NAME = ?";
        $st  = ibase_prepare($conn, $sql);
        $rs  = ibase_execute($st, strtoupper($name));

        return (bool) ibase_fetch_row($rs);
    }

}

/**
 * Проверка за генератор
 */
if (!function_exists('h_generator_exists')) {

    function h_generator_exists($conn, string $name): bool {
        $sql = "SELECT 1 FROM RDB\$GENERATORS WHERE RDB\$GENERATOR_NAME = ?";
        $st  = ibase_prepare($conn, $sql);
        $rs  = ibase_execute($st, strtoupper($name));

        return (bool) ibase_fetch_row($rs);
    }

}

/**
 * Дали е достъпен сървара на Firebird
 */
if (!function_exists('h_isReachableFB')) {

    function h_isReachableFB() {

        if (empty($_ENV['app.gensoftEnable'])) {
            return;
        }

        $settingsGensoft = service('settings') -> get('App.gensoft') ?? [];
        $fb              = service('firebirdConnection');

        $missingConfig = [];
        $offlineHosts  = [];

        $hosts = [
            [
                'value' => $settingsGensoft['gensoftSrv'] ?? '',
                'label' => 'основен',
            ],
            [
                'value' => $settingsGensoft['gensoftSrv2'] ?? '',
                'label' => 'допълнителен',
            ],
        ];

        /* Проверка за липсващи настройки
         * ------------------------------------ */
        foreach ($hosts as $host) {
            if ($host['value'] === '') {
                $missingConfig[] = $host['label'];
            }
        }

        if (!empty($missingConfig)) {
            echo sprintf('<span class="bg-red p-2">
                            <strong class="fa fa-exclamation-triangle"></strong>
                            &nbsp;&nbsp; Липсва настройка за Gensoft сървър: %s!
                         </span>', implode(', ', $missingConfig));
            return;
        }

        /* Проверка за връзка
         * ------------------------------------ */
        foreach ($hosts as $host) {
            $ip = h_extractIp($host['value']);

            if (!$fb -> isReachable($ip)) {
                $offlineHosts[] = $host['label'];
            }
        }

        if (!empty($offlineHosts)) {
            echo sprintf('<span class="bg-red p-2">
                                <strong class="fa fa-exclamation-triangle"></strong>
                                &nbsp;&nbsp; Няма връзка с Gensoft сървър: %s!
                             </span>', implode(', ', $offlineHosts));
        }
    }

}
