<?php

// app/Helpers/CustomHelper.php
if (!function_exists('generate_colorRows')) {

    function generate_colorRows($data = []) {

        foreach ($data['colorRows'] as $v) {
            $_trStyle        = ($v['isMain'] != 'Y') ? '' : 'height: 50px';
            $_colorRowIsMain = ( $v['isMain'] == 'Y') ? 'h3' : '';

            $_deleteIconTitle = lang('LANG__global.tbl.btn.title.delete');
            $_editIconTitle   = lang('LANG__global.tbl.btn.title.edit');
            $_moveIconTitle   = lang('LANG__global.tbl.btn.title.move');

            $var = <<<HTML
 <tr class="colorRows text-center" style="{$_trStyle}">
    <td class="colorRows-data align-middle" colspan="2">
        <input class="colorRows-pos" type="hidden" name="colorRows[colorRows][][pos]" value="{$v['pos']}">
        <input type="hidden" name="colorRows[colorRows][][text]" value="{$v['text']}">
        <input type="hidden" name="colorRows[colorRows][][backgColor]" value="{$v['backgColor']}">
        <input type="hidden" name="colorRows[colorRows][][textColor]" value="{$v['textColor']}">
        <input type="hidden" name="colorRows[colorRows][][isMain]" value="{$v['isMain']}">
        
        <div>
            <i class="delete_colorRow btn-outline-danger p-1 border-0 fa fa-trash" title="{$_deleteIconTitle}"></i>
            <i class="edit_colorRow btn-outline-primary p-1 border-0 fa fa-edit" title="{$_editIconTitle}"></i>
            <i class="btn-outline-dark p-1 border-0 fa fa-arrows" title="{$_moveIconTitle}"></i>
            <i class="rowPosition btn-outline-dark p-1 border-0 fa fa-list"></i>
        </div>
    </td>
            
    <td class="text {$_colorRowIsMain} font-weight-bold {$v['textColor']}" 
        style="background:{$v['backgColor']}" colspan="{$data['colspan']}" >{$v['text']}
    </td>
</tr> 
HTML;

            if ($data['key'] == $v['pos']) {
                echo $var;
            } elseif ($data['key'] == array_key_last($data['list']) && $data['key'] < $v['pos']) {
                // ако позицията е последна
                $arr[] = $var;
            }
        }

        return $arr ?? [];
    }

}

