<?php

namespace App\Controllers\users;

class Users extends \App\Controllers\BaseController {

    private $configIonAuth;

    public function __construct() {
        parent::__construct();
        $this -> configIonAuth = config('IonAuth');

        if (!empty($this -> configIonAuth -> templates['errors']['list'])) {
            $this -> validationListTemplate = $this -> configIonAuth -> templates['errors']['list'];
        }
    }

    // view ==============================
    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__users.breadcrumbs.info'), '/');

        $data = [
            'page_title' => 'Потребители',
            'breadcrumb' => $this -> breadcrumb -> render(),
            'addCSS'     => $this -> addCSS(),
            'addJS'      => $this -> addJS(),
            'message'    => session() -> getFlashdata('message'),
            //'isLogedUser' => $this -> ionAuth -> loggedIn(),
            //'currentUser' => $this -> ionAuth -> user() -> row(),
            'acl2'       => $this -> acl,
            'users'      => $this -> ionAuth -> users() -> result(),
            'groups'     => $this -> ionAuth -> groups() -> result(),
            // VIEWS -----------------------------------------------------
            'view_table' => 'users/VIEW__users-table',
                //'view_list_groups' => 'users/VIEW__users_table-groups',
        ];

        foreach ($data['users'] as $k => $user) {
            $data['users'][$k] -> groups = $this -> ionAuth -> getUsersGroups($user -> id) -> getResult();
        }

        return $this -> render_template('users/VIEW__users', $data);
    }

    public function save_user($id) {

        $form      = array_map('trim', $this -> request -> getPost());
        $groupData = $form['groups'] ?? [];

        if (is_numeric($id)) {
            if ($this -> ionAuth -> isAdmin()) {
                // Update the groups user belongs to

                if (!empty($groupData)) {
                    $this -> ionAuth -> removeFromGroup('', $id);
                    $this -> ionAuth -> addToGroup($groupData, $id);
                }
            }

            // check to see if we are updating the user 
            return json_encode(
                    $this -> ionAuth -> update($id, $form) ?
                    'потребителя e обновен' :
                    'Грешка при обновяване на потребител');
        } else {
            $this -> validation -> setRules([
                'username'      => ['label' => str_replace(':', '', lang('Auth.login_identity_label')), 'rules' => 'required'],
                'password'      => ['label' => str_replace(':', '', lang('Auth.login_password_label')), 'rules' => 'required'],
                'againPassword' => ['label' => 'Повтори паролата', 'rules' => 'required|matches[password]'],
                'groups'        => ['label' => 'Група', 'rules' => 'required']
            ]);

            if ($this -> validation -> withRequest($this -> request) -> run()) {
                if ($this -> ionAuth -> register(
                                $form['username'],
                                $form['password'],
                                $form['email'],
                                ['first_name' => $form['first_name']],
                                [$groupData]
                        )) {

                    $this -> returnResponse(true, $form['username'], lang('popup/LANGpop__klient.returnResponse.ok.newKlient'), 1);
                    return json_encode('');
                }
            }
 
            $err = $this -> validation -> getErrors();

            $msg = $this -> validation -> getErrors() ?
                    view($this -> show_alert, ['errors' => $err]) :
                    ($this -> ionAuth -> errors($this -> validationListTemplate) ?
                    view($this -> show_alert, []) :
                    $this -> session -> getFlashdata('message'));

            return json_encode(['success' => false, 'msg' => $msg]);
        }
    }

    // ИЗтриване на потребител от базата
    // =================================================================
    public function delete_user(int $id, $name = null) {

        if ($id) {
            $this -> ionAuth -> deleteUser($id);
            $this -> returnResponse(true, $name, 'изтрит потребител', 1);
        } else {
            $this -> returnResponse(false, null, 'Липсва ID на потребител', 1);
        }
        return redirect() -> back();
    }

    // активиране на потребител в базата
    // ============================================================
    public function activate(int $id): \CodeIgniter\HTTP\RedirectResponse {

        $this -> ionAuth -> activate($id);
        session() -> setFlashdata('message', $this -> ionAuth -> messages());
        return redirect() -> back();
    }

    // деактивиране на потребител в базата
    // ============================================================
    public function deactivate(int $id) {
//        if (!$this -> isAuthorized()) {
//            // redirect them to the home page because they must be an administrator to view this
//            throw new \Exception('You must be an administrator to view this page.');
//        }

        $validation = \Config\Services::validation();

        $validation -> setRule('confirm', lang('Auth.deactivate_validation_confirm_label'), 'required');
        $validation -> setRule('id', lang('Auth.deactivate_validation_user_id_label'), 'required|integer');

        // do we have a valid request?
        if (!$id) {
            throw new \Exception(lang('Auth.error_security'));
        }

        // do we have the right userlevel?
        if ($this -> ionAuth -> loggedIn() && $this -> ionAuth -> isAdmin()) {
            $message = $this -> ionAuth -> deactivate($id) ? $this -> ionAuth -> messages() : $this -> ionAuth -> errors();
            session() -> setFlashdata('message', $message);
        }

        return redirect() -> back();
    }

    public function addCSS() {

        return [
            'css/users/groupPermisions',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [
            'plugins/tableSearchRow/tableSearchRow',
            'plugins/stickyTableHeaders/stickytableheaders',
        ];
        $default = ['js/users/users'];
        $modals  = [];

        return array_merge($global, $plugins, $default, $modals);
    }

}
