<?php

namespace App\Controllers\users;

class Groups extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();

        if (!$this -> ionAuth -> isAdmin()) {
            // Проверка дали имаме достъп до view(страницата)
            $_viewTab = ['view' => $_REQUEST['tab'] ?? ''];

            if (!$this -> acl -> isAllowed($this -> group -> id, $_viewTab, null)) {
                header('Location: ' . $_SERVER['HTTP_REFERER']);
                $this -> returnResponse(false, '', 'Достъпът до Потребители е забранен!!', 1);
                // $this -> session -> setFlashdata('message', 'Достъпът до Потребители е забранен!!');
            }
        }

        $this -> lang = [
            'groupList_title' => lang('GroupUser_lang.groupList_title'),
            'newGroup_btn'    => lang('GroupUser_lang.newGroup_btn'),
            'index_group_th'  => lang('GroupUser_lang.index_group_th'),
            'save_btn'        => lang('Btns.save'),
            'group_name_txt'  => lang('GroupUser_lang.group_name'),
            'deskr_txt'       => lang('GroupUser_lang.deskr')
        ];
    }

    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__users.breadcrumbs.info'), '/');

        $data = [
            'page_title' => 'Потребители',
            'breadcrumb' => $this -> breadcrumb -> render(),
            'addCSS'     => $this -> addCSS(),
            'addJS'      => $this -> addJS(),
            'message'    => session() -> getFlashdata('message'),
            'acl2'       => $this -> acl,
            'groups'     => $this -> ionAuth -> groups() -> result(),
            // VIEWS -----------------------------------------------------
            'view_table' => 'users/VIEW__groups-table',
        ];

        return $this -> render_template('users/VIEW__users', $data);
    }

    public function save_group($id) {

        $form = array_map('trim', $this -> request -> getPost());

        if (empty($form)) {
            return $this -> response -> setJSON(['success' => false, 'msg' => 'Невалидни данни.']);
        }

        if (is_numeric($id)) {
            $this -> ionAuth -> updateGroup($id, $form['group_name'], ['description' => $form['description']]);
            $this -> returnResponse(true, $form['group_name'], 'обновена група', 1);
            return json_encode('');
        }

        // Създаване на нова група (валидирай само при създаване)
        $this -> validation -> setRules([
            'group_name' => ['label' => 'Група', 'rules' => 'required'],
        ]);

        if (!$this -> validation -> withRequest($this -> request) -> run()) {
            $errors = $this -> validation -> getErrors();
            $msg    = view($this -> show_alert, ['errors' => $errors]);

            return $this -> response -> setJSON(['success' => false, 'msg' => $msg]);
        }

        // Проверка за дублиране (по избор)
        if ($this -> groupExists($form['group_name'])) {
            return $this -> response -> setJSON(['success' => false, 'msg'     => view($this -> show_alert, ['errors' => ["Група с това име {$form['group_name']} вече съществува."]]),
            ]);
        }

        if ($this -> ionAuth -> createGroup($form['group_name'], $form['description'])) {
            $this -> returnResponse(true, $form['group_name'], 'създадена нова група', 1);
        }

        // $errors = $this -> ionAuth -> errors();
        // return $this -> response -> setJSON(['success' => false, 'msg' => $errors]);

        return json_encode('');
    }

    // ИЗтриване на потребител от базата
    // =================================================================
    public function delete_group(int $id, $name = null) {

        if ($id) {
            $delete = $this -> ionAuth -> deleteGroup($id);
            $this -> returnResponse($delete, $name, 'изтрита група', 1);
        } else {
            $this -> returnResponse(false, $name, 'Липсва ID', 1);
        }

        return redirect() -> back();
    }

    private function groupExists(string $groupName): bool {
        $db      = \Config\Database::connect();
        $builder = $db -> table('groups');
        return $builder -> where('name', $groupName) -> countAllResults() > 0;
    }

    public function addCSS() {

        return [
            'css/users/groupPermisions',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global  = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions',
        ];
        $plugins = [];
        $default = ['js/users/groups'];
        $modals  = [];

        return array_merge($global, $plugins, $default, $modals);
    }

}
