<?php

namespace App\Controllers\users;

class Group_permisions extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();
        $this -> db = \Config\Database::connect();
    }

    /*
      |--------------------------------------------------------
      | ИЗВЛ. НА ПРАВАТА ЗА ГРУПА
      |------------------------------------------------------- */

    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__users.breadcrumbs.info'), '/');

        if ($this -> request -> getGet()) {
            $selectedGroupId = $this -> request -> getVar('selectedGroupId');
        }

        $data = [
            'page_title'           => 'Групи права',
            'breadcrumb'           => $this -> breadcrumb -> render(),
            'addCSS'               => $this -> addCSS(),
            'addJS'                => $this -> addJS(),
            'ctrl'                 => [
                'groups'          => $this -> ionAuth -> groups() -> result(),
                'selectedGroupId' => $selectedGroupId ?? 0,
            ],
            'message'              => session() -> getFlashdata('message'),
            //'group'      => $this -> ionAuth -> group($id) -> row()
            // views
            'view_table'           => 'users/VIEW__groupsPermisions',
            'view_groupPermisions' => [
                'modules' => 'users/groupPermisions/VIEW__groupsPermisions-modules',
                'forms'   => 'users/groupPermisions/VIEW__groupsPermisions-forms',
            ]
        ];

        return $this -> render_template('users/VIEW__users', $data);
    }

    public function save_groupPermisions($groupId = null) {
        $form = $this -> request -> getPost();

        if (empty($groupId)) {
            return redirect() -> back() -> with('error', 'Липсват данни.');
        }

        $data = [
            'group_id'  => $groupId,
            'resource ' => !empty($form) ? json_encode($form, JSON_UNESCAPED_UNICODE) : null
        ];

        $this -> db -> table('groups_permissions') -> upsert($data);
    }

    // ЗАПИС НА ПРАВАТА ЗА ГРУПА
    // ------------------------------
//    public function set_groupPermisions($id = null) {
//        $form = $this -> request -> getPost();
//
//        $data = [
//            'group_id'         => $id,
//            'view_tab_allowed' => !empty($form['view_tab_allowed']) ? json_encode($form['view_tab_allowed'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) : null,
//            //'view_allowed'     => !empty($form['view_tab_allowed']) ? json_encode($form['view_allowed'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) : null,
//            'btns_allowed'     => !empty($form['btns_allowed']) ? json_encode($form['btns_allowed'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) : null
//        ];
//        //dd(json_encode($form, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
//
//        $this -> db -> table('groups_permissions')
//                -> upsert($data);
//    }
    // ==== зареждане на css файлове в header на html странiцата ====
    // --------------------------------------------------------------
    public function addCSS() {

        return [
            'css/users/groupPermisions',
        ];
    }

    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins',
            'js/_Global/inOfer/tableActions',
        ];

        $plugins = [];
        $default = ['js/users/groupPermision'];
        $modals  = [];

        return array_merge($global, $plugins, $default, $modals);
    }

}
