<?php

namespace App\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Models\spisak\MODEL__product;
use \App\Libraries\Pagination;

class Product extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();

        //$this -> checkgroupAccess('sp', $single = 1);

        $this -> MODEL__global  = new MODEL__global();
        $this -> MODEL__product = new MODEL__product();
        $this -> Pagination_lib = new Pagination();
    }

    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__product.breadcrumbs.info'), '/');

        $perPage    = $this -> request -> getVar('perPage') ?? 10;
        $page       = (int) $this -> request -> getVar('page');
        $col        = $this -> request -> getVar('col');
        $searchName = $this -> request -> getVar('searchName');
        $categoryId = $this -> request -> getVar('categoryId');

        $sortCol       = $this -> request -> getVar('sort_col');
        $sortOrder     = $this -> request -> getVar('sort_order');
        $getCategories = $this -> MODEL__global -> get__all_categories();

        $countTotalProducts = $this -> MODEL__global -> count__all_product($categoryId, $col, $searchName);

        $offset      = ($page > 1) ? ($perPage * ($page - 1)) : 0;
        $total_pages = ceil($countTotalProducts / ($perPage ?: 1)); // ako $perPage ==0
        $pagination  = $this -> Pagination_lib -> generate(['page' => $page, 'total_pages' => $total_pages]);

        $categories = $this -> buildCategoryTree(null, $getCategories);
        $products   = $this -> MODEL__product -> get__all_product($searchName, $categoryId, $col, ['col' => $sortCol, 'sortOrder' => $sortOrder], ['offset' => $offset, 'per_page' => $perPage]);

        $data = [
            'page_title'         => lang('LANG__product.title'),
            'breadcrumb'         => $this -> breadcrumb -> render(),
            'addCSS'             => $this -> addCSS(),
            'addJS'              => $this -> addJS(),
            'message'            => session() -> getFlashdata('message') ?? '',
            'list'               => $products,
            'categories'         => $categories,
            'countTotalProducts' => $countTotalProducts,
            'pagination'         => $pagination,
            'mqrka'              => $this -> MODEL__global -> get__mqrka(),
            'acl'                => $this -> acl,
            //'scats'      => $this -> MODEL__product -> get__subCategory($product_id),
            'view_table'         => 'spisak/product/VIEW__product-table',
        ];

        return $this -> render_template('spisak/product/VIEW__product', $data);
    }

    public function change_categoryOnProducts() {
        $productIds         = $this -> request -> getVar('productIds');
        $selectedCategoryId = $this -> request -> getVar('selectedCategoryId');

        $this -> MODEL__product -> change_categoryOnProducts($selectedCategoryId, $productIds);

        return json_encode('');
    }

    // обновяване на наличността за избраните или за всички продукти
    public function save_nalich() {
        $productIds = $this -> request -> getVar('productIds');
        $value      = $this -> request -> getVar('value');

        $this -> MODEL__product -> save_nalich($productIds, $value);
        return json_encode('');
    }

    // КЛОНИРАНЕ НА ПРОДУКТ
    // ---------------------------------------------------------------
    public function clone($id) {

        $newProductName = $this -> request -> getVar('newProductName');

        $sql = $this -> MODEL__product -> clone_product($id, $newProductName);

        if (isset($sql['dub'])) {
            return json_encode(['dub' => true, 'data' => lang('popup/LANGpop__editProduct.js.alert.dubProdName', [$newProductName])]);
        }

        $this -> returnResponse(true, $newProductName, lang('LANG__product.returnResponse.ok.cloneProduct'), 1);

        return json_encode('');
    }

    // ИЗТРИВАНЕ НА ПРОДУКТ
    // ---------------------------------------------------------------
    public function delete() {
        $urlParams   = $this -> request -> getVar();
        $id          = $urlParams['product_id'];
        $productName = $urlParams['product_name'];

        $response = $this -> MODEL__product -> delete_product($id, $productName);

        if ($response == null) {
            $this -> returnResponse(true, $productName, lang('LANG__product.returnResponse.ok.deleteProduct'), 1);
        } else {
            $this -> returnResponse($response, 'err-in-view-product', lang('LANG__product.returnResponse.err.productInZeList', [$productName]), 1);
        }

        return redirect() -> back();
    }

    // ==== зареждане на css файлове в header на html странiцата ====
    // --------------------------------------------------------------
    public function addCSS() {

        return [
            'plugins/jTippy_popupTitle/jTippy.min',
        ];
    }

    // === зареждане на js файлове в footer на html страноцата ======
    // --------------------------------------------------------------
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/img/jquery.elevatezoom',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/tblColumnToggle/jquery.columntoggle',
            'plugins/tblColumnToggle/jquery.pageLength'
        ];
        $default = ['js/spisak/produkt/produkt'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
