<?php

namespace App\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Libraries\Pagination;
use \App\Models\spisak\MODEL__nashiFirmi;

class NashiFirmi extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__nashiFirmi = new MODEL__nashiFirmi();
        $this -> Pagination_lib    = new Pagination();
    }

    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__nashaFirma.breadcrumbs.info'), '/');

        $perPage    = $this -> request -> getVar('perPage') ?? 10;
        $page       = (int) $this -> request -> getVar('page');
        $col        = $this -> request -> getVar('col');
        $searchName = $this -> request -> getVar('searchName');

        $sortCol   = $this -> request -> getVar('sort_col');
        $sortOrder = $this -> request -> getVar('sort_order');

        $countTotalPag = $this -> MODEL__nashiFirmi -> count__all_nashiFirmi($col, $searchName);

        $offset      = ($page > 1) ? ($perPage * ($page - 1)) : 0;
        $total_pages = ceil($countTotalPag / ($perPage ?: 1)); // ako $perPage ==0
        $pagination  = $this -> Pagination_lib -> generate(['tab' => 'null', 'page' => $page, 'perPage' => $perPage, 'total_pages' => $total_pages, 'searchName' => $searchName, 'col' => $col]);

        $data = [
            'page_title'    => lang('LANG__nashaFirma.title'),
            'breadcrumb'    => $this -> breadcrumb -> render(),
            'addCSS'        => $this -> addCSS(),
            'addJS'         => $this -> addJS(),
            'message'       => session() -> getFlashdata('message'),
            'list'          => $this -> MODEL__nashiFirmi -> get__all_nashiFirmi($searchName, $col, ['col' => $sortCol, 'sortOrder' => $sortOrder], ['offset' => $offset, 'per_page' => $perPage]),
            'countTotalPag' => $countTotalPag,
            'pagination'    => $pagination,
            'acl'           => $this -> acl,
            'view_table'    => 'spisak/nashiFirmi/VIEW__nashiFirmi-table',
        ];

        // при търсене по име в филтъра
        if ($this -> request -> isAjax()) {
            return json_encode(view($data['view_table'], $data));
        }

        return $this -> render_template('spisak/nashiFirmi/VIEW__nashiFirmi', $data);
    }

    // ==== зареждане на css файлове в header на html странiцата =====
    // ---------------------------------------------------------------
    public function delete($id, $productName) {

        $response = $this -> MODEL__nashiFirmi -> delete_nashaFirma($id, $productName);

        if ($response == null) {
            $this -> returnResponse(true, $productName, lang('LANG__nashaFirma.returnResponse.ok.deleteNashFirma'), 1);
        }

        return redirect() -> back();
    }

    // ==== зареждане на css файлове в header на html странiцата ====
    // --------------------------------------------------------------
    public function addCSS() {

        return [
            'plugins/jTippy_popupTitle/jTippy.min',
        ];
    }

    // === зареждане на js файлове в footer на html страноцата ======
    // --------------------------------------------------------------
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
             //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/tblColumnToggle/jquery.columntoggle',
            'plugins/tblColumnToggle/jquery.pageLength'
        ];
        $default = ['js/spisak/nashaFirma/nashaFirma'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
