<?php

namespace App\Controllers\spisak;

use \App\Models\common\MODEL__global;
use \App\Models\spisak\MODEL__klient;
use \App\Libraries\Pagination;

class Klient extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();
        // $this -> checkgroupAccess('sp', $single = 1);

        $this -> MODEL__global  = new MODEL__global();
        $this -> MODEL__klient  = new MODEL__klient();
        $this -> Pagination_lib = new Pagination();
    }

    public function index() {
        $this -> breadcrumb -> add('Home', '/');
        $this -> breadcrumb -> add(lang('LANG__klient.breadcrumbs.info'), '/');

        $tab        = $this -> request -> getVar('tab');
        $perPage    = $this -> request -> getVar('perPage') ?? 10;
        $page       = (int) $this -> request -> getVar('page');
        $col        = $this -> request -> getVar('col');
        $searchName = $this -> request -> getVar('searchName');

        $sortCol   = $this -> request -> getVar('sort_col');
        $sortOrder = $this -> request -> getVar('sort_order');

        $countTotalPag = $this -> MODEL__klient -> count__all_klient($tab, $col, $searchName);

        $offset      = ($page > 1) ? ($perPage * ($page - 1)) : 0;
        $total_pages = ceil($countTotalPag / ($perPage ?: 1)); // ako $perPage ==0
        $pagination  = $this -> Pagination_lib -> generate(['page' => $page, 'total_pages' => $total_pages]);

        $data = [
            'page_title'    => lang('LANG__klient.title'),
            'breadcrumb'    => $this -> breadcrumb -> render(),
            'addCSS'        => $this -> addCSS(),
            'addJS'         => $this -> addJS(),
            'message'       => session() -> getFlashdata('message'),
            'list'          => $this -> MODEL__klient -> get__all_klient($tab, $searchName, $col, ['col' => $sortCol, 'sortOrder' => $sortOrder], ['offset' => $offset, 'per_page' => $perPage]),
            'countTotalPag' => $countTotalPag,
            'pagination'    => $pagination,
            'acl'           => $this -> acl,
            'view_table'    => 'spisak/klient/VIEW__klient-table',
        ];

        return $this -> render_template('spisak/klient/VIEW__klient', $data);
    }

    public function change_priceLevel() {
        $klientIds          = $this -> request -> getVar('klientIds');
        $selectedPriceLevel = $this -> request -> getVar('selectedPriceLevel');

        $this -> MODEL__klient -> change_priceLevel($selectedPriceLevel, $klientIds);
        return json_encode('');
    }

    // ==== зареждане на css файлове в header на html странiцата =====
    // ---------------------------------------------------------------
    public function delete() {
        $urlParams = $this -> request -> getGet();

        $response = $this -> MODEL__klient -> delete_klient($urlParams['id']);

        if ($response == null) {    
            $this -> returnResponse(true, $urlParams['name'], 'изтрит', 1);
        } else {
            // $this -> returnResponse($response, 'err-in-view-product', 'Този продукт ' . $klientName . '<br> присъства в следните листи:<br><br>', 1);
        }

        return redirect() -> back();
    }

    // ==== зареждане на css файлове в header на html странiцата ====
    // --------------------------------------------------------------
    public function addCSS() {

        return [
            'plugins/jTippy_popupTitle/jTippy.min',
        ];
    }

    // === зареждане на js файлове в footer на html страноцата ======
    // --------------------------------------------------------------
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/tblColumnToggle/jquery.columntoggle',
            'plugins/tblColumnToggle/jquery.pageLength'
        ];
        $default = ['js/spisak/klient/klient'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
