<?php

namespace App\Controllers\common;

use \App\Models\common\MODEL__dropdown;

//use \App\Models\common\MODEL__all_oferta;

class Dropdown extends \App\Controllers\BaseController {

    public function __construct() {
        parent::__construct();

        // $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__dropdown = new MODEL__dropdown();
        helper('url');
    }

    public function renderView() {
        $form   = $this -> request -> getVar('form') ?? '';
        $tip    = $this -> request -> getVar('tip') ?? '';
        $search = $this -> request -> getVar('searchText') ?? '';

        // url атрибути на заявката
        $params = [
            'tip'          => $tip,
            'search'       => $search,
            'brandId'      => $form['brand_id'] ?? '',
            'firstModelId' => $form['model_id'] ?? '',
            'productId'    => $form['product_id'] ?? '',
        ];

        // карта с променливи
        $configMap = [
            'brand'          => [
                'headerTxt'   => 'Марка',
                'dataAttr'    => ['data-id' => 'id', 'data-image-path' => 'img'], //връзка с dbColumns[id] and dbColumns[img]
                'allowedBtns' => ['save', 'edit', 'delete'],
                'dbColumns'   => [
                    'id'    => 'brand_id',
                    'label' => 'brandTxt',
                    'img'   => 'image_brand',
                ],
            ],
            'model'          => [
                'headerTxt'     => 'Модел',
                'dataAttr'      => ['data-id' => 'id', 'data-image-path' => 'img'], //връзка с dbColumns[id] and dbColumns[img]
                'allowedBtns'   => ['save', 'edit', 'delete'],
                'htmlSelectors' => '#brandId',
                'dbColumns'     => [
                    'id'    => 'model_id',
                    'label' => 'model',
                    'img'   => 'image_model',
                ],
                'requires'      => [$params['brandId']],
            ],
            'modelAddt'      => [
                'headerTxt'         => 'Допълнителни модели',
                'linkToMainModelId' => $params['firstModelId'],
                'route'             => 'Dropdown-set_modelAddt',
                'dataAttr'          => ['data-id' => 'id'], //връзка с dbColumns[id] 
                'allowedBtns'       => ['chk'],
                'htmlSelectors'     => '#productId2, #brandId, #brand_model_id',
                'dbColumns'         => [
                    'id'     => 'model_id',
                    'label'  => 'model',
                    'cheked' => 'isChecked',
                ],
            // 'requires'      => [$params['brandId']],
            ],
            'modelYear'      => [
                'headerTxt'     => 'Година',
                'dataAttr'      => ['data-id' => 'id'], //връзка с dbColumns[id]
                'allowedBtns'   => ['save', 'edit', 'delete'],
                'htmlSelectors' => '#brandId, #brand_model_id',
                'dbColumns'     => [
                    'id'    => 'model_property_id',
                    'label' => 'm_property_text',
                ],
                'requires'      => [$params['brandId'], $params['firstModelId']],
            ],
            'modelKupe'      => [
                'headerTxt'     => 'Купе',
                'dataAttr'      => ['data-id' => 'id'], //връзка с dbColumns[id]
                'allowedBtns'   => ['save', 'edit', 'delete'],
                'htmlSelectors' => '#brandId, #brand_model_id',
                'dbColumns'     => [
                    'id'    => 'model_property_id',
                    'label' => 'm_property_text',
                ],
                'requires'      => [$params['brandId'], $params['firstModelId']],
            ],
            'prodCharValues' => [
                'headerTxt'     => 'Х-ки на продукта',
                'route'         => 'Dropdown-setProductAttrText',
                'dataAttr'      => ['data-id' => 'id'], //връзка с dbColumns[id]
                'allowedBtns'   => ['save', 'edit', 'delete'],
                'htmlSelectors' => '#productId2',
                'dbColumns'     => [
                    'id'    => 'product_characteristic_value_id',
                    'label' => 'product_characteristic_text',
                ],
            ]
        ];

        if (!isset($configMap[$tip])) {
            return redirect() -> back() -> with('error', 'Невалиден тип заявка.');
        }

        // Проверка на задължителни 
        foreach ($configMap[$tip]['requires'] ?? [] as $req) {
            if (empty($req)) {
                $msg     = $req === 'brandId' ? 'марка' : ($req === 'firstModelId' ? 'модел' : $req);
                $results = ['errorMessage' => "Моля, първо изберете {$msg}."];
                break;
            }
        }

        if (empty($results) && ($tip !== 'prodCharValues' || ($tip === 'prodCharValues' && !empty($params['search'])))) {
            $results = $this -> MODEL__dropdown -> loadDropdown($params);
        }

        $data['ctrl'] = [
            'tip'          => $tip,
            'configMap'    => $configMap[$tip],
            'results'      => $results ?? null,
            'errorMessage' => $results['errorMessage'] ?? null,
            'searchText'   => $search,
        ];

        return view('common/dropdown/VIEW__dropdown', $data);
    }

    public function new() {
        $response = $this -> MODEL__dropdown -> insert_new($this -> request -> getPost());

        return json_encode($response, JSON_UNESCAPED_UNICODE);
    }

    public function update() {
        $response = $this -> MODEL__dropdown -> update_item($this -> request -> getPost());

        return json_encode($response, JSON_UNESCAPED_UNICODE);
    }

    public function delete() {
        $name = $this -> request -> getVar('name');
        $id   = $this -> request -> getVar('id');
        $tip  = $this -> request -> getVar('tip');

        $data = [
            'primaryId' => $id,
            'name'      => $name,
            'tip'       => $tip,
        ];

        $response = $this -> MODEL__dropdown -> delete_item($data);

        return empty($response['err']) ? json_encode('ok') : json_encode($response);
    }

    // изтриване на вече присвоена х-ка
    public function remove_productAttribute() {
        $var      = $this -> request -> getVar();
        $response = $this -> MODEL__dropdown -> remove_productAttribute($var['productCharId']);

        return json_encode($response);
    }

    // присвояаване на пруктова х-ка към х-ка на подкатегория
    public function set_text_toProductAttribute($prodCharId = null) {
        $var      = $this -> request -> getPost();
        $response = $this -> MODEL__dropdown -> set_text_toProductAttribute($prodCharId, $var);

        return json_encode($response);
    }

    // присвояаване на доп модели към главния избран модел
    public function set_modelAddt() {
        $var = $this -> request -> getVar();

        $response = $this -> MODEL__dropdown -> set_multipleModels($var);
        return json_encode($response);
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
