<?php

namespace App\Controllers;

use CodeIgniter\Files\File;

class ResizeImage extends BaseController {

    public function __construct() {
        parent::__construct();
    }

// Helper function to convert the image to Base64


    public static function resize($image, $width = 120, $height = 120) {
        $mediaRoot = '/home/offeooye/' . $_ENV['app.mediaRoot'];
        $image     = urldecode($image);
        $file      = $mediaRoot . 'productImages/' . $image;
        $dataUri   = '';

        $imagePathInfo = pathinfo($image);   // Cache the result of pathinfo
        $subfolder     = $imagePathInfo['dirname'];

        $cacheSubfolder = $mediaRoot . 'cache/ofer/' . $subfolder;

        // Create cache folder if it doesn't exist
        if (!is_dir($cacheSubfolder)) {
            mkdir($cacheSubfolder, 0755, true);  // Recursively create subfolder
        }

        // Generate cache file path
        $cacheFile = $cacheSubfolder . '/' . basename($image);

        // Check if cached image exists
        if (file_exists($cacheFile)) {
            // Return cached image in base64 format
            $imageData = file_get_contents($cacheFile);
            $base64    = base64_encode($imageData);
            $mimeType  = mime_content_type($cacheFile);
            return 'data:' . $mimeType . ';base64,' . $base64;
        }

        // Check if the source file exists
        if (!file_exists($file)) {
          
            return '';  // Return empty string if the file is missing
        }

        // Detect image format and create resource
        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        switch ($extension) {
            case 'png':
                $imageResource = @imagecreatefrompng($file);
                $content_type  = 'image/png';
                break;
            case 'jpeg':
            case 'jpg':
                $imageResource = @imagecreatefromjpeg($file);
                $content_type  = 'image/jpeg';
                break;
            default:
                return '';  // Return empty string for unsupported image types
        }

        if (!$imageResource) {
            return '';  // Return empty string if image creation fails
        }

        // Get original image dimensions
        $origWidth  = imagesx($imageResource);
        $origHeight = imagesy($imageResource);

        // Calculate new dimensions while maintaining aspect ratio
        $ratio     = min($width / $origWidth, $height / $origHeight);
        $newWidth  = (int) ($origWidth * $ratio);
        $newHeight = (int) ($origHeight * $ratio);

        // Create a blank canvas for the new image
        $imageC   = imagecreatetruecolor($width, $height);
        $bg_color = imagecolorallocate($imageC, 255, 255, 255); // White background

        imagefill($imageC, 0, 0, $bg_color);

        // Center the resized image
        $x = ($width - $newWidth) / 2;
        $y = ($height - $newHeight) / 2;

        // Copy and resize the image
        imagecopyresampled($imageC, $imageResource, $x, $y, 0, 0, $newWidth, $newHeight, $origWidth, $origHeight);

        // Start output buffering only when needed
        ob_start();

        // Output the image in the appropriate format and save to cache
        if ($content_type == 'image/png') {
            imagepng($imageC);
        } else {
            imagejpeg($imageC, $cacheFile, 85);  // Save a high-quality JPEG to cache
        }

        // Free memory
        imagedestroy($imageResource);
        imagedestroy($imageC);

        // Get image data from the buffer and encode to base64
        $contents = ob_get_clean();
        $dataUri  = 'data:' . $content_type . ';base64,' . base64_encode($contents);

        return $dataUri;
    }

}
