<?php

namespace App\Controllers;

use \App\Models\common\MODEL__global;
use \App\Models\common\MODEL__all_oferta;
use \App\Models\oferta\dostavka\MODEL__dostavka;

class Dostavka extends BaseController {

    private $sqlTable = '_dostavka';

    public function __construct() {
        parent::__construct();

        $this -> MODEL__global     = new MODEL__global();
        $this -> MODEL__all_oferta = new MODEL__all_oferta();
        $this -> MODEL__dostavka   = new MODEL__dostavka();
        helper('url');
    }

    public function index($id = null, $arg = 'dostavka') {

        //$this -> breadcrumb -> add('Home', '/');
        // $this -> breadcrumb -> add('Поръчки', '/');

        $data = [
            'page_title'     => lang('LANG__promo.breadcrumbs.info'),
            // 'breadcrumbs'    => $this -> breadcrumb -> render(),
            'addCSS'         => $this -> addCSS(),
            'addJS'          => $this -> addJS(),
            //'ofer'           => $this -> MODEL__all_oferta -> get__ofer_by_id($this -> sqlTable, $id),
            'status'         => $this -> MODEL__global -> get__status(),
            'productList'    => $this -> MODEL__all_oferta -> get__products_forOfer($id, $arg),
            'self'           => $this -> MODEL__dostavka -> get__dostavkaBy_id($id),
            'kontragents'    => $this -> MODEL__global -> get__kontragents(),
            'zenovaLista'    => $this -> MODEL__global -> get__zenovaLista(),
            'mqrka'          => $this -> MODEL__global -> get__mqrka(),
            'razmer'         => $this -> MODEL__global -> get__razmer(),
            'teglo'          => $this -> MODEL__global -> get__teglo(),
            // 'valuta'         => $this -> MODEL__global -> get__valuta(),
            // VIEWS -----------------------------------------------------
            'view_leftAside' => 'oferta/dostavka/VIEW__dostavka-leftAside',
            'view_htmlTable' => 'oferta/dostavka/VIEW__dostavka-table',
            'view_files'     => 'oferta/dostavka/VIEW__dostavka-files',
            'view_actionBtn' => 'oferta/dostavka/VIEW__dostavka-actionBtn'
        ];

        return $this -> render_template('oferta/promo/VIEW__promo', $data);
    }

    // зареждане на css файлове в header на html странiцата
    // ====================================================
    public function addCSS() {

        return [
            'plugins/currency-flags/currency-flags',
            'css/layouts/autocomplete',
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/choose-color/choose-color',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/timepicker/datepicker',
        ];
    }

    // зареждане на js файлове в footer на html страноцата
    // ====================================================
    public function addJS() {

        $global = [
            'js/_Global/ajax_config',
            'js/_Global/loadPlugins'
        ];

        $plugins = [
            'plugins/jTippy_popupTitle/jTippy.min',
            'plugins/tableRow_move/tableRow_move',
            'plugins/jqueryAlert/jqueryConfirm',
            'plugins/img/jquery.elevatezoom',
            'plugins/tableSearchRow/tableSearchRow',
             //'plugins/stickyTableHeaders/jquery.table.freezeHeader',
            'plugins/stickyTableHeaders/stickytableheaders',
            'plugins/timepicker/datepicker',
            'plugins/choose-color/choose-color',
        ];
        $default = ['js/oferta/special/special'];
        $modals  = [];

        return array_merge($plugins, $global, $default, $modals);
    }

}

////echo json_encode($arr_merged, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT);
 //
//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
