<?php

namespace App\Controllers\Dashboard;

use App\Controllers\BaseController;

class Deliveries extends BaseController
{
    public function index()
    {
        include APPPATH . 'Controllers/Dashboard/DeliveriesData.php';

        $monthsBack     = (int)($this->request->getGet('months') ?? 6);      // период за анализ (3/6/12)
        $deliveryPeriod = (int)($this->request->getGet('deliveryPeriod') ?? $monthsBack); // колко месеца без доставка
        $percent        = (int)($this->request->getGet('percent') ?? 10);    // % от продадените
        $group          = $this->request->getGet('group');                   // филтър по група

        $data = $deliveriesData;
        if (!$data) return $this->response->setJSON(['items' => []]);

        // 🧭 Намираме най-новата дата
        $latestDate = null;
        foreach ($data as $row) {
            $d = \DateTime::createFromFormat('m/d/Y', $row['От дата']);
            if ($d && (!$latestDate || $d > $latestDate)) $latestDate = $d;
        }
        if (!$latestDate) return $this->response->setJSON(['items' => []]);

        // ⚙️ Граници
        $fromDate = (clone $latestDate)->modify("-{$monthsBack} months");
        $staleBefore = (clone $latestDate)->modify("-{$deliveryPeriod} months");

        // 🗂️ Групиране по продукт
        $aggregated = [];
        foreach ($data as $r) {
            $d = \DateTime::createFromFormat('m/d/Y', $r['От дата']);
            if (!$d) continue;

            // филтър по група
            if ($group && $r['Главна група'] !== $group && $r['Група'] !== $group) continue;

            // само последните X месеца
            if ($d < $fromDate) continue;

            // филтър по процент
            if ($percent > 0 && $r['Налични'] > ($r['Продадени'] * $percent / 100)) continue;

            $key = $r['Група'] . '|' . $r['Стока'];
            if (!isset($aggregated[$key])) {
                $aggregated[$key] = [
                    'Група' => $r['Група'],
                    'Стока' => $r['Стока'],
                    'minDate' => $d,
                    'maxDate' => $d,
                    'Продадени' => (int)$r['Продадени'],
                    'Налични' => (int)$r['Налични']
                ];
            } else {
                if ($d < $aggregated[$key]['minDate']) $aggregated[$key]['minDate'] = $d;
                if ($d > $aggregated[$key]['maxDate']) $aggregated[$key]['maxDate'] = $d;
                $aggregated[$key]['Продадени'] += (int)$r['Продадени'];
                $aggregated[$key]['Налични'] += (int)$r['Налични'];
            }
        }

        // 🕒 Филтър за залежали — последна доставка по-стара от X месеца
        $filtered = [];
        foreach ($aggregated as $r) {
            // ако последната доставка е по-стара от границата и има налични
            if ($r['maxDate'] < $staleBefore && $r['Налични'] > 0) {
                $filtered[] = [
                    'Група' => $r['Група'],
                    'Стока' => $r['Стока'],
                    'Последна доставка' => $r['maxDate']->format('d.m.Y'),
                    'Продадени' => $r['Продадени'],
                    'Налични' => $r['Налични']
                ];
            }
        }

        // ако няма "залежали", върни последните доставки (за да не е празно)
        if (empty($filtered)) {
            foreach ($aggregated as $r) {
                $filtered[] = [
                    'Група' => $r['Група'],
                    'Стока' => $r['Стока'],
                    'Последна доставка' => $r['maxDate']->format('d.m.Y'),
                    'Продадени' => $r['Продадени'],
                    'Налични' => $r['Налични']
                ];
            }
        }

        // 🔢 сортиране по дата
        usort($filtered, function ($a, $b) {
            $ad = \DateTime::createFromFormat('d.m.Y', $a['Последна доставка']);
            $bd = \DateTime::createFromFormat('d.m.Y', $b['Последна доставка']);
            return $ad <=> $bd;
        });

        return $this->response->setJSON(['items' => $filtered]);
    }
}
