<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use \App\Models\common\MODEL__global;

//  top -icd1
// pkill -f /path/to/script.php    ili pkill -o за спиране на всички задачи cron
class Cron extends Controller {

    // подготвяне на базата данни на Gensoft при първо инициализиране
    public function gensoftPrepareDb() {
        ob_start();
        require ROOTPATH . 'interbase/gensoft_first_load.php';
        $out = ob_get_clean();
        return $this -> response -> setContentType('text/plain') -> setBody($out);
    }

    public function cli_order_notifications() {
        $mopdel                = $this -> MODEL__global = new MODEL__global();
        $response              = $mopdel -> get__orders_count_notification();
        echo (int) $response;
    }

    // ръчно импортване на gensoft данни
    public function import_gensoftData() {
        $script = ROOTPATH . 'interbase/import_Gensof_from_hosting.php';
        $log    = '/tmp/gensoft_log.txt';

        // Изчистваме стария лог
        file_put_contents($log, "");

        // Стартираме CLI процес във фонов режим
        exec("php $script > $log 2>&1 &");

        // Веднага връщаме отговор към браузъра
        return $this -> response -> setJSON([
                    'status'   => 'started',
                    'message'  => 'Импортът е стартиран във фонов режим.',
                    'log_path' => $log
        ]);
    }

}
