<?php

namespace App\Controllers;

use \App\Models\MODEL__apiQurier;

class ApiQurier extends BaseController {

    public function __construct() {
        parent::__construct();

        $this -> MODEL__apiQurier = new MODEL__apiQurier();
    }

    public function econt_action($arr = []) {
        $method   = $this -> request -> getVar('method');
        $cityName = $this -> request -> getVar('cityName');

        if (!empty($arr)) {
            $method   = $arr['method'];
            $cityName = $arr['cityName'];
        }

        if ($method == 'get_cities') {
            $url = "https://ee.econt.com/json_rpc.php?skip_loading_session=1";

            $data = [
                //'id'      => 7422243211769657212,
                'jsonrpc' => '2.0',
                //'method'  => 'Suggest.suggestCity',
                'method'  => 'ApiExternalSuggest.getCities',
                'params'  => [
                    //'params' => ['country' => 1033],
                    'text' => $cityName
                ]
            ];

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json'
            ]);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }
        }

        if ($method == 'get_ofices') {
            $cityId = $this -> request -> getVar('cityId');

            $response = $this ::EcontRequest("Nomenclatures/NomenclaturesService.getOffices.json", array(
                        'cityID'      => $cityId,
                        'countryCode' => 'BGR'
            ));
        }

        return json_encode($response, JSON_UNESCAPED_UNICODE);
    }

    public static function EcontRequest($method, $params = array(), $endpoint = 'https://ee.econt.com/services', $timeout = 10) {
        $settings = (object) (service('settings') -> get('App.general') ?? []);

        //production endpoint
        $auth['login']    = $settings -> econtUser ?? '';
        $auth['password'] = $settings -> econtPass ?? '';

        //$auth['login']    = 'Valpers';
        //$auth['password'] = 'valpers2002';
        //testing endpoint
        //$endpoint = 'https://demo.econt.com/ee/services';
        // this is an example only, replace with proper credentials.

        $ch         = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint . '/' . rtrim($method, '/'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
        if (!empty($auth))
            curl_setopt($ch, CURLOPT_USERPWD, $auth['login'] . ':' . $auth['password']);
        if (!empty($params))
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_TIMEOUT, !empty($timeout) && intval($timeout) ? $timeout : 4);
        $response   = curl_exec($ch);
        $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $jsonResponse = json_decode($response, true);

        if (!$jsonResponse) {
            throw new \Exception("Invalid response.");
        }
        if (strpos($httpStatus, '2') !== 0) {

            $msg         = trim($jsonResponse['message']);
            $innerMsgs   = array();
            foreach ($jsonResponse['innerErrors'] as $e)
                $innerMsgs[] = self::flattenError($e);
            if (!empty($msg) && !empty($innerMsgs)) {
                $msg .= ": ";
            }
            return ['error' => $msg . implode("; ", array_filter($innerMsgs))];

            // throw new \Exception(self::flattenError($jsonResponse));//simple error handling by combining all the returned error's messages
        } else {
            return $jsonResponse;
        }
    }

    public static function flattenError($err) {
        $msg         = trim($err['message']);
        $innerMsgs   = array();
        foreach ($err['innerErrors'] as $e)
            $innerMsgs[] = self::flattenError($e);
        if (!empty($msg) && !empty($innerMsgs)) {
            $msg .= ": ";
        }
        return $msg . implode("; ", array_filter($innerMsgs));
    }

    function econt_createLabel($data = []) {
        $settings = service('settings') -> get('App.general') ?? [];
        $preval   = $settings['preval'] ?? [];
        $currency = $preval['base_currency'] ?? 'BGN';

        $profil          = $this::EcontRequest("Profile/ProfileService.getClientProfiles.json", array(0));
        $profil          = $profil['profiles'][$data['profilSender']];
        $agent           = $this::EcontRequest(null, null, 'https://ee.econt.com/suggest_autocorrect.php?method=GetEeReadyParcelAgent&id_client=' . $profil['client']['id']);
        $pAdrIndex       = $data['senderAdres'];
        $deliveryDate    = !empty($data['delivery_date']) ? date('Y-m-d', strtotime($data['delivery_date'])) : 'workday';
        $tovaritelnizaNo = $data['tovaritelnizaNo'];
        $curier_zaqvka   = [];

        if ($data['isOfice'] == 1) {
            $deliveryDate = '';

            // извличане на офис кода
            // име на града в който изпращаме
            $cityName = $this -> econt_action([
                'method'   => 'get_cities',
                'cityName' => $data['adres']['city']['name']
                    ]
            );
            // id на град
            $cityId   = json_decode(json_decode($cityName, true), true)['result']['cities'][0]['id'] ?? null;

            if ($cityId) {
                $officesData = $this::EcontRequest('Nomenclatures/NomenclaturesService.getOffices.json', ['cityID' => $cityId]);
                // масив с офиси В този град

                foreach ($officesData['offices'] ?? [] as $row) {
                    if ($row['name'] === $data['ofisName']) {
                        $data['receiverOfficeCode'] = $row['code']; // само кода на града
                        break;
                    }
                }
            }
        }

        $arr = array(
            'mode'  => 'create',
            'label' => array(
                'shipmentNumber'      => $tovaritelnizaNo,
                'senderClient'        => [
                    'name'         => $profil['client']['name'],
                    'phones'       => $profil['client']['phones'],
                    'clientNumber' => $profil['client']['clientNumber']
                ],
                "senderAgent"         => [
                    "name"   => $agent['data'][$data['profilAgents']]['value'],
                    "phones" => [
                        $agent['data'][$data['profilAgents']]['phone']
                    ],
                    "email"  => $agent['data'][$data['profilAgents']]['email']
                ],
                'senderAddress'       => [
                    'city'        => [
                        'country'  => ['code3' => 'BGR'],
                        'name'     => $profil['addresses'][$pAdrIndex]['city']['name'],
                        'postCode' => $profil['addresses'][$pAdrIndex]['city']['postCode'],
                    ],
                    'fullAddress' => $profil['addresses'][$pAdrIndex]['fullAddress'],
                    'street'      => $profil['addresses'][$pAdrIndex]['street'],
                    'num'         => $profil['addresses'][$pAdrIndex]['num'],
                    'quarter'     => $profil['addresses'][$pAdrIndex]['quarter'],
                    'other'       => $profil['addresses'][$pAdrIndex]['other'],
                ],
                'senderOfficeCode'    => preg_match('/\d+(\.\d+)?/', $data['senderOfficeCode'], $matches) ? $matches[0] : '',
                // $profil['profiles'][1]['addresses'][0],
                'receiverClient'      => array(
                    'name'   => $data['client']['name'],
                    'phones' => $data['client']['phone']
                ),
                'receiverAgent'       => array(
                    'name'   => $data['client']['liceKont'],
                    'phones' => $data['client']['phone']
                ),
                'receiverAddress'     => array(
                    'city'    => array(
                        //'id'       => 41,
                        'postCode' => $data['adres']['city']['postCode'],
                        'name'     => $data['adres']['city']['name']
                    ),
                    'quarter' => $data['adres']['quarter']['name'],
                    'street'  => $data['adres']['street']['name'],
                    'num'     => $data['adres']['street']['num'],
                    'other'   => $data['adres']['other']
                ),
                'receiverOfficeCode'  => $data['receiverOfficeCode'],
                'orderNumber'         => $data['orderId'],
                //'sendDate'            => $data['sendDate'],
                'holidayDeliveryDay'  => $deliveryDate,
                //'sendDate'            => strtotime('10.04.2023'), //strtotime('10.06.2023'),
                'packCount'           => $data['packCount'],
                'shipmentType'        => $data['opakovka'],
                'weight'              => empty($data['grandWeight']) ? 1 : $data['grandWeight'],
                'sizeUnder60cm'       => $data['sizeUnder60cm'] ?? 0,
                'keepUpright'         => $data['keepUpright'] ?? 0,
                // размери
//                'shipmentDimensionsL' => '',
//                'shipmentDimensionsW' => '',
//                'shipmentDimensionsH' => '',
                'shipmentDescription' => $data['shipmentDescription'],
                'services'            => array(
                    'declaredValueAmount'   => isset($data['isCdAmount']) ? $data['services']['declaredValueAmount'] : '', // обяв с-т
                    'declaredValueCurrency' => $currency,
                    'cdAmount'              => isset($data['isNplatez']) ? $data['services']['cdAmount'] : '', //Наложен платеж
                    'cdType'                => 'get',
                    'cdCurrency'            => $currency,
                    'cdPayOptionsTemplate'  => $data['cdPayOptions'],
                    'invoiceBeforePayCD'    => $data['invoiceBeforePay'] ?? 0,
                    'smsNotification'       => $data['sms'] ?? 0,
                    'deliveryReceipt'       => $data['obrRazpiska'] ?? 0,
                    'goodsReceipt'          => $data['obrStRazpiska'] ?? 0,
                ),
                'instruction'         => array(
                    'type'                    => 'return',
                    //'applyToAllParcels'       => 1,
                    'returnInstructionParams' => [
                        //'returnParcelDestination' => 'sender',
                        'returnParcelPaymentSide' => $data['returnParcelPaymentSide'], // при връщане на пратка
                        'returnParcelIsDocument'  => 1,
                        'signatureDocuments'      => $data['signature'] ?? 0,
                    ]
                ),
                // 'smsOnDelivery'                  => $data['sms'] ?? '',
                'emailOnDelivery'     => isset($data['isEmailToMe']) ? $data['emailOnDelivery'] : '',
                'payAfterTest'        => $data['test'] ?? 0,
                'payAfterAccept'      => $data['check'] ?? 0
            )
        );

        $arr['label'] += match ($data['payment']) {
            'za_smetkaMe' => ['paymentSenderMethod' => $data['paymentOptions']], // за сметка на подател
            'za_smetkaPoluchatel' => ['paymentReceiverMethod' => 'cash'],
            'za_smetkaShare' =>
            [
                'paymentSenderMethod'            => $data['paymentOptions'],
                'paymentReceiverMethod'          => 'cash',
                'paymentReceiverAmountIsPercent' => true,
                'paymentReceiverAmount'          => '50'
            ],
            'za_smetkaCustom' =>
            [
                'paymentSenderMethod'            => $data['paymentOptions'],
                'paymentReceiverMethod'          => 'cash',
                'paymentReceiverAmountIsPercent' => false,
                'paymentReceiverAmount'          => $data['paymentReceiverValue']
            ],
        };

        if ($data['isOfice'] != 0) {
            unset($arr['label']['receiverAddress']);
        } else {
            unset($arr['label']['receiverOfficeCode']);
        }

        //$arr = $arr + $curier_zaqvka;
        //dd($data);
        $requestStr = empty($tovaritelnizaNo) ? 'createLabel' : 'updateLabel';
        $response   = $this ::EcontRequest("Shipments/LabelService.$requestStr.json", $arr);

//        if ($requestStr == 'createLabel' && $data['sendFrom'] === 'fromDoor' && !empty($response['label']['shipmentNumber']) && !empty($data['requestHourFrom']) && !empty($data['requestHourTo'])) {
//            $courierResp = $this -> econt_requestCurier($response['label']['shipmentNumber'], $profil, $agent, $data, $pAdrIndex);
//
//            if (!empty($courierResp['error'])) {
//                $response['error_requestCurier'] = $courierResp['error'];
//            }
//        }

        return $response;
    }

    public function econt_deleteLabel($tovaritelnizaNo = '') {

        $arr = [
            'shipmentNumbers' => [$tovaritelnizaNo]
        ];

        return $response = $this::EcontRequest('Shipments/LabelService.deleteLabels.json', $arr);
    }

    function econt_requestCurier($data = []) {
        date_default_timezone_set('Europe/Sofia'); // Българско време

        $profil = $data['isSpeedy'] ? json_decode($this -> ApiQurier -> speedy_profilSender()) -> clients : $profil = $this::EcontRequest("Profile/ProfileService.getClientProfiles.json", array(0));

        $profil    = $profil['profiles'][$data['profilSender']];
        $agent     = $this::EcontRequest(null, null, 'https://ee.econt.com/suggest_autocorrect.php?method=GetEeReadyParcelAgent&id_client=' . $profil['client']['id']);
        $pAdrIndex = $data['senderAdres'];
        $date      = $data['requestDate'];

        // Форматиране на часовете и минутите с водеща нула
        $hourFrom = str_pad($data['requestHourFrom'], 2, '0', STR_PAD_LEFT);
        $minFrom  = str_pad($data['requestMinFrom'], 2, '0', STR_PAD_LEFT);
        $hourTo   = str_pad($data['requestHourTo'], 2, '0', STR_PAD_LEFT);
        $minTo    = str_pad($data['requestMinTo'], 2, '0', STR_PAD_LEFT);

        // ISO 8601 формат с offset +03:00
        $requestTimeFrom = "$date $hourFrom:$minFrom:00";
        $requestTimeTo   = "$date $hourTo:$minTo:00";

        $response = $this ::EcontRequest("Shipments/ShipmentService.requestCourier.json", array(
                    'shipmentNumber'  => $data['tovaritelnizaNo'],
                    'requestTimeFrom' => $requestTimeFrom,
                    'requestTimeTo'   => $requestTimeTo,
                    'packCount'       => $data['packCount'],
                    'shipmentType'    => $data['opakovka'],
                    'shipmentWeight'  => $data['grandWeight'] ?? 1,
                    'senderClient'    => [
                        'name'         => $profil['client']['name'],
                        'phones'       => $profil['client']['phones'],
                        'clientNumber' => $profil['client']['clientNumber']
                    ],
                    'senderAgent'     => [
                        "name"   => $agent['data'][$data['profilAgents']]['value'],
                        "phones" => [
                            $agent['data'][$data['profilAgents']]['phone']
                        ],
                        "email"  => $agent['data'][$data['profilAgents']]['email']
                    ],
                    'senderAddress'   => [
                        'city'        => [
                            'name'     => $profil['addresses'][$pAdrIndex]['city']['name'],
                            'postCode' => $profil['addresses'][$pAdrIndex]['city']['postCode'],
                        ],
                        'fullAddress' => $profil['addresses'][$pAdrIndex]['fullAddress'],
                        'street'      => $profil['addresses'][$pAdrIndex]['street'],
                        'num'         => $profil['addresses'][$pAdrIndex]['num'],
                        'quarter'     => $profil['addresses'][$pAdrIndex]['quarter'],
                        'other'       => $profil['addresses'][$pAdrIndex]['other'],
                    ],
                    'attachShipments' => [$data['tovaritelnizaNo']],
        ));

        return $response;
    }

    function econt_calculateDostavka($data = []) {

        $profil = $this::EcontRequest("Profile/ProfileService.getClientProfiles.json", array(0));

        $response = $this ::EcontRequest("Shipments/LabelService.createLabel.json", array(
                    'mode'  => 'calculate',
                    'label' => array(
                        'senderAddress'      => $profil['profiles'][0]['addresses'][0],
                        'receiverAddress'    => array(
                            'city'   => array(
                                //'postCode' => $data['calc']['postCode'],
                                'name' => $data['grad']
                            ),
                            'street' => 'f',
                        ),
                        'receiverOfficeCode' => $data['isOfice'],
                        'packCount'          => $data['packCount'] ?? 1,
                        'shipmentType'       => $data['opakovka'] ?? 'pack',
                        'weight'             => $data['weight']
                    )
        ));

        $totalPrice = $response['label']['totalPrice'];

        return json_encode(['totalPrice' => sprintf('%0.2f', $totalPrice)]);
    }

    function econt_get_allOfices($data = []) {

        $response = $this ::EcontRequest("Nomenclatures/NomenclaturesService.getOffices.json", array(
                    'cityID'      => $data['cityId'],
                    'countryCode' => 'BGR'
        ));

        return json_encode($response);
    }

    public function speedyRequest($location = null, $jsonData = []) {
        $settings = (object) (service('settings') -> get('App.general') ?? []);

        $jsonData += array(
            'userName'  => $settings -> speedyUser ?? '',
            'password'  => $settings -> speedyPass ?? '',
            'language'  => 'BG',
            'countryId' => '100',
        );

        if (in_array('unsetCountryId', $jsonData)) {
            unset($jsonData['countryId'], $jsonData[0]);
        }

        if (isset($arg['canselShipment'])) {
            $location = $arg['canselShipment']['location'];
            $jsonData += $arg['canselShipment']['arg'];
            //_______________________________________
        } elseif (isset($arg['getAllOfices'])) {
            $location = 'location/office';
            $jsonData += ['name' => $arg['cityName']];
        } elseif (isset($arg['search'])) {
            // $location = $this -> request -> getVar('location');
            $location = $arg['location'];
            $jsonData += ['name' => $arg['name'], 'siteId' => $arg['cityId']];
            //_____________________________________
        } elseif (isset($arg['calculateDostavka'])) {

            $location = 'calculate/';
            $jsonData += [
                'sender'    => ['clientId' => $arg['profilSender'] -> clientId],
                'recipient' =>
                (isset($arg['tk_order']['office_id']) && $arg['tk_order']['office_id'] != '') ?
                [
            'privatePerson'  => true,
            'pickupOfficeId' => $arg['tk_order']['office_id']
                ] :
                [
            'privatePerson'   => true,
            'addressLocation' => ['siteId' => $arg['tk_order']['city_id']]
                ],
                'service'   => [
                    "autoAdjustPickupDate" => true,
                    "serviceIds"           => [505],
                ],
                'content'   => [
                    'parcelsCount' => 1,
                    'totalWeight'  => $arg['calc']['totalWeight']
                ],
                'payment'   => ['courierServicePayer' => 'RECIPIENT'],
            ];
        }
        //dd($jsonData);
        $jsonDataEncoded = json_encode($jsonData);
        // dd($jsonDataEncoded);

        $curl         = curl_init('https://api.speedy.bg/v1/' . $location);
        curl_setopt($curl, CURLOPT_POST, 1); // Tell cURL that we want to send a POST request.
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // Verify the peer's SSL certificate.
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); // Stop showing results on the screen.
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5); // The number of seconds to wait while trying to connect. Use 0 to wait indefinitely.
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8'));
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsonDataEncoded); // Attach our encoded JSON string to the POST fields.
        #-> Get the response
        $jsonResponse = curl_exec($curl);

        if ($jsonResponse === FALSE) {
            exit("cURL Error: " . curl_error($curl));
        }
        // dd(json_decode($jsonResponse));
        return($jsonResponse);
    }

    public function speedy_createLabel($data = []) {
        $tovaritelnizaNo = $data['tovaritelnizaNo'] ?? '';

        if ($data['isOfice'] != 0) {
            unset($data['recipient']['address']);

            $grad     = trim($data['grad'] ?? '');
            $ofisName = trim($data['ofisName'] ?? '');
            $offices  = json_decode($this -> speedyRequest('location/office', ['name' => $grad]), true);

            if (!empty($offices['offices'])) {
                foreach ($offices['offices'] as $row) {
                    if ($row['name'] == $ofisName) {
                        $data['recipient']['pickupOfficeId'] = $row['id']; // само кода на града
                        break;
                    }
                }
            }
        } else {
            unset($data['recipient']['pickupOfficeId']);
        }

        $data['service']['additionalServices']['cod']['cardPaymentForbidden'] = false;

        foreach (['packagePayer', 'declaredValuePayer'] as $key) {
            if (($data['payment'][$key] ?? '') == 'SAME') {
                unset($data['payment'][$key]);
            }
        }

        $jsonData = [
            'id'        => $tovaritelnizaNo,
            'sender'    => $data['sender'],
            'recipient' => $data['recipient'],
            'service'   => $data['service'],
            'content'   => $data['content'],
            'payment'   => $data['payment'],
            'ref1'      => $data['ref1']
        ];
        //d($jsonData);
        $response = $this ::speedyRequest('shipment/' . (!empty($tovaritelnizaNo) ? 'update' : ''), $jsonData);

        return $response;
    }

    public function speedy_profilSender() {
        $response = $this ::speedyRequest('client/contract');
        return $response;
    }

    public function speedy_deleteLabel($parcelId = null) {
        if (empty($parcelId)) {
            return;
        }

        return $this -> speedyRequest('shipment/cancel', [
                    'shipmentId' => $parcelId,
                    'comment'    => 'CANSEL'
        ]);
    }

    // tyrseне на град  за autocomplete, когато е до адрес
    public function get_speeedyOficeData() {
        $siteId   = $this -> request -> getVar('siteId');
        $location = 'location/office/' . $siteId['id'];
        $jsonData = ['unsetCountryId'];

        $jsonResponse = json_encode(json_decode($this -> speedyRequest($location, $jsonData)));
        return $jsonResponse;
    }

    // калулиране цена на доставка за куриер
    public function api_calculateDostavka($isEcont = '') {
        $urlParams = $this -> request -> getBody();

        $urlParams = json_decode($urlParams, true);

        return match ($isEcont) {
            'econt_office', 'econt_door', 'econt_machina' => $this -> econt_calculateDostavka($urlParams),
            'speedy_office', 'speedy_door', 'speedy_machina' => json_encode(json_decode($this -> ApiQurier -> speedyRequest([
                                'calculateDostavka' => true,
                                'profilSender'      => json_decode($this -> ApiQurier -> speedyRequest(['profilSender' => 1] + $auth)) -> clients[0]
                                    ] + $auth + $form)) -> calculations[0]),
            default => null,
        };
    }

    // tyrseне на град  за autocomplete, когато е до адрес
    public function search_cityByName() {
        $name     = $this -> request -> getVar('cityName');
        $location = 'location/site';

        $jsonData = [
            'siteId' => $_ENV['app.localSite'],
            'name'   => $name
        ];

        $result = json_encode(json_decode($this -> speedyRequest($location, $jsonData)));
        return $result;
    }

}

//return $this -> response -> setJSON(json_encode($data['selectOptions'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT));
