<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\AnalyticsModel;

class Tracker extends BaseController
{
    // For GET test
    public function status()
    {
        return $this->response->setJSON([
            "status" => "OK",
            "message" => "Analytics endpoint is working."
        ]);
    }

    // For OPTIONS (CORS preflight)
    public function options()
    {
        return $this->response->setStatusCode(200);
    }

    // For POST data
    public function collect()
    {
        $data = $this->request->getJSON(true);

        if (!$data) {
            return $this->response->setJSON(['error' => 'No data received']);
        }

        $m = new AnalyticsModel();
        $m->insert($data);

        return $this->response->setJSON(['success' => true]);
    }
}
