<?php

namespace App\Controllers\Ajax;

use App\Controllers\BaseController;
use App\Modules\popupForm\Models\spisak\MODELpop__categorySEO;
use App\Modules\popupForm\Models\product\MODELpop__productSEO;
use \App\Libraries\Pagination;

class SeoController extends BaseController {

    public function bulkIndex() {
        $ids = $this -> request -> getPost("ids");

        if (!is_array($ids) || empty($ids)) {
            return $this -> response -> setJSON(["status" => "error"]);
        }

        $db = \Config\Database::connect();

        // ако няма SEO запис – създаваме
        $db -> query(
                "
        INSERT INTO _product_seo (product_id, noindex)
        SELECT p.product_id, 0
        FROM _product p
        WHERE p.product_id IN (" .
                implode(",", array_map("intval", $ids)) .
                ")
        AND NOT EXISTS (
            SELECT 1 FROM _product_seo s WHERE s.product_id = p.product_id
        )
    "
        );

        // UPDATE
        $db -> query(
                "
        UPDATE _product_seo
        SET noindex = 0
        WHERE product_id IN (" .
                implode(",", array_map("intval", $ids)) .
                ")
    "
        );

        return $this -> response -> setJSON(["status" => "success"]);
    }

    public function bulkNoindex() {
        $ids = $this -> request -> getPost("ids");

        if (!is_array($ids) || empty($ids)) {
            return $this -> response -> setJSON(["status" => "error"]);
        }

        $db = \Config\Database::connect();

        // ако няма SEO запис – създаваме
        $db -> query(
                "
        INSERT INTO _product_seo (product_id, noindex)
        SELECT p.product_id, 1
        FROM _product p
        WHERE p.product_id IN (" .
                implode(",", array_map("intval", $ids)) .
                ")
        AND NOT EXISTS (
            SELECT 1 FROM _product_seo s WHERE s.product_id = p.product_id
        )
    "
        );

        // UPDATE
        $db -> query(
                "
        UPDATE _product_seo
        SET noindex = 1
        WHERE product_id IN (" .
                implode(",", array_map("intval", $ids)) .
                ")
    "
        );

        return $this -> response -> setJSON(["status" => "success"]);
    }

    public function autoGenerate() {
        $data = $this -> request -> getPost();

        $productId = $data["product_id"] ?? 0;
        if (!$productId) {
            return $this -> response -> setJSON([
                        "status" => "error",
                        "msg"    => "Missing product ID",
            ]);
        }

        // Взимаме данните на продукта
        $db      = \Config\Database::connect();
        $product = $db
                -> table("_product")
                -> where("product_id", $productId)
                -> get()
                -> getRowArray();

        if (!$product) {
            return $this -> response -> setJSON([
                        "status" => "error",
                        "msg"    => "Product not found",
            ]);
        }

        // ГЕНЕРИРАМЕ НОВО SEO (важното!)
        $model  = new MODELpop__productSEO();
        $newSEO = $model -> generateFreshSEO($product);

        return $this -> response -> setJSON([
                    "status" => "success",
                    "data"   => $newSEO,
        ]);
    }

    public function autoGenerateAll() {
        $db = \Config\Database::connect();

        // 1. Взимаме всички продукти + евентуалното им SEO
        $rows = $db
                -> query(
                        "
        SELECT 
            p.product_id,
            p.product_name,
            p.short_description,
            p.description,
            s.seo_id
        FROM _product p
        LEFT JOIN _product_seo s ON s.product_id = p.product_id
    "
                )
                -> getResultArray();

        foreach ($rows as $r) {
            // 2. Генерираме ДЕФОЛТНО SEO (НЕ fresh)
            $seo_title       = trim($r["product_name"]);
            $seo_description = mb_substr(
                    strip_tags($r["short_description"] ?: $r["description"]),
                               0,
                               160
            );
            $focus_keyword   = trim($r["product_name"]);
            $seo_slug        = url_title($r["product_name"], "-", true);
            $canonical_url   = "/" . $seo_slug;

            if ($r["seo_id"]) {
                // 3. UPDATE (има запис)
                $db -> query(
                        "
                UPDATE _product_seo SET
                    seo_title = ?,
                    seo_description = ?,
                    focus_keyword = ?,
                    seo_slug = ?,
                    canonical_url = ?
                WHERE product_id = ?
            ",
                        [
                            $seo_title,
                            $seo_description,
                            $focus_keyword,
                            $seo_slug,
                            $canonical_url,
                            $r["product_id"],
                        ]
                );
            } else {
                // 4. INSERT (няма запис)
                $db -> query(
                        "
                INSERT INTO _product_seo
                (product_id, seo_title, seo_description, focus_keyword, seo_slug, canonical_url, noindex)
                VALUES (?, ?, ?, ?, ?, ?, 0)
            ",
                        [
                            $r["product_id"],
                            $seo_title,
                            $seo_description,
                            $focus_keyword,
                            $seo_slug,
                            $canonical_url,
                        ]
                );
            }
        }

        return $this -> response -> setJSON(["status" => "success"]);
    }

    public function list($limit = []) {
        $mode   = $this -> request -> getGet("mode");
        $search = trim($this -> request -> getGet("search") ?? "");
        $db = \Config\Database::connect();

        /* ============================================================
          CATEGORIES MODE
          ============================================================ */
        if ($mode === "categories") {
            $builder = $db
                    -> table("_category c")
                    -> select(
                            "
                    c.category_id,
                    c.category_name,
                    s.seo_id,
                    s.seo_title,
                    s.seo_description,
                    s.focus_keyword,
                    s.canonical_url,
                    s.noindex,
                    s.seo_slug
                "
                    )
                    -> join("_category_seo s", "s.category_id = c.category_id", "left");

            if ($search !== "") {
                $builder -> like("c.category_name", $search);
            }

            $countBuilder = clone $builder;
            $totalRows    = $countBuilder -> countAllResults(false);

            if ($limit) {
                $builder -> limit($limit['per_page'], $limit['offset']);
            }

            $rows = $builder -> orderBy("c.category_id") -> get() -> getResultArray();

            $seoModel = new MODELpop__categorySEO();

            foreach ($rows as &$r) {
                // FORCE INDEX BY DEFAULT
                if ($r["noindex"] === null) {
                    $r["noindex"] = 1;
                }

                $input = [
                    "category_id"          => $r["category_id"],
                    "category_name"        => $r["category_name"] ?? "",
                    "category_description" => "",
                    "seo_title"            => $r["seo_title"] ?? "",
                    "seo_description"      => $r["seo_description"] ?? "",
                    "focus_keyword"        => $r["focus_keyword"] ?? "",
                    "canonical_url"        => $r["canonical_url"] ?? "",
                    "seo_slug"             => $r["seo_slug"] ?? "",
                    "noindex"              => $r["noindex"],
                ];

                $defaults = $seoModel -> generateDefaultSEO($input);

                foreach (
                [
                    "seo_title",
                    "seo_description",
                    "focus_keyword",
                    "canonical_url",
                    "seo_slug",
                    "noindex",
                ]
                as $k
                ) {
                    $r[$k] = $defaults[$k];
                }

                $r["name"] = $r["category_name"];
            }

            if ($this -> request -> isAjax()) {
                return json_encode($rows);
            }
            return ['rows' => $rows, 'totalRows' => $totalRows];
        }

        /* ============================================================
          PRODUCTS MODE
          ============================================================ */
        $builder = $db -> table("_product p")
                -> select('p.product_id, p.product_name, p.short_description, p.description,
                      p.kod, p.oem, p.brand_id, p.model_id,
                      s.seo_id, s.seo_title, s.seo_description, 
                      s.focus_keyword, s.canonical_url, s.noindex, s.seo_slug'
                )
                -> join("_product_seo s", "s.product_id = p.product_id", "left");

        $categoryId = $this -> request -> getGet("category_id");

        if (!empty($categoryId)) {
            $builder -> where("p.category_id", (int) $categoryId);
        }
        if ($search !== "") {
            $builder -> like("p.product_name", $search);
        }

        $countBuilder = clone $builder;
        $totalRows    = $countBuilder -> countAllResults(false);

        if ($limit) {
            $builder -> limit($limit['per_page'], $limit['offset']);
        }

        $rows = $builder -> orderBy("p.product_id") -> get() -> getResultArray();

        $seoModel = new MODELpop__productSEO();

        foreach ($rows as &$r) {
            // FORCE INDEX BY DEFAULT
            if ($r["noindex"] === null) {
                $r["noindex"] = 1;
            }

            $input = [
                "product_id"        => $r["product_id"],
                "product_name"      => $r["product_name"] ?? "",
                "short_description" => $r["short_description"] ?? "",
                "description"       => $r["description"] ?? "",
                "kod"               => $r["kod"] ?? "",
                "oem"               => $r["oem"] ?? "",
                "seo_title"         => $r["seo_title"] ?? "",
                "seo_description"   => $r["seo_description"] ?? "",
                "focus_keyword"     => $r["focus_keyword"] ?? "",
                "canonical_url"     => $r["canonical_url"] ?? "",
                "seo_slug"          => $r["seo_slug"] ?? "",
                "noindex"           => $r["noindex"],
            ];

            $defaults = $seoModel -> generateDefaultSEO($input);

            foreach (
            [
                "seo_title",
                "seo_description",
                "focus_keyword",
                "canonical_url",
                "seo_slug",
                "noindex",
            ]
            as $k
            ) {
                $r[$k] = $defaults[$k];
            }

            $r["name"] = $r["product_name"];
        }

        if ($this -> request -> isAjax()) {
            return json_encode($rows);
        }
        return ['rows' => $rows, 'totalRows' => $totalRows];
    }

    /* ============================================================
      SAVE
      ============================================================ */

    public function save() {
        $data = $this -> request -> getPost();

        log_message("error", "SEO SAVE: " . print_r($data, true));

        $mode  = $data["mode"] ?? "products";
        $id    = $data["id"] ?? 0;
        $field = $data["name"] ?? "";
        $value = $data["value"] ?? "";

        $model = $mode === "categories" ? new MODELpop__categorySEO() : new MODELpop__productSEO();

        $extra = [
            "product_id"  => $data["product_id"] ?? null,
            "category_id" => $data["category_id"] ?? null,
        ];

        $status = $model -> updateField($id, $field, $value, $extra);

        return $this -> response -> setJSON([
                    "status" => $status ? "success" : "error",
        ]);
    }

    public function categories() {
        $db = \Config\Database::connect();

        return $this -> response -> setJSON(
                        $db
                                -> table("_category")
                                -> select("category_id, category_name")
                                -> orderBy("category_name")
                                -> get()
                                -> getResultArray()
        );
    }

}
