<?php

namespace Config;

use CodeIgniter\Events\Events;
use CodeIgniter\Exceptions\FrameworkException;
use CodeIgniter\HotReloader\HotReloader;

/*
 * --------------------------------------------------------------------
 * Application Events
 * --------------------------------------------------------------------
 * Events allow you to tap into the execution of the program without
 * modifying or extending core files. This file provides a central
 * location to define your events, though they can always be added
 * at run-time, also, if needed.
 *
 * You create code that can execute by subscribing to events with
 * the 'on()' method. This accepts any form of callable, including
 * Closures, that will be executed when the event is triggered.
 *
 * Example:
 *      Events::on('create', [$myInstance, 'myMethod']);
 */

//Events::on('post_controller_constructor', function () {
//
//
//    \Sentry\init([
//        'dsn'                  => 'https://f2c44c2b65f3ac44e81ae8fcf2a53650@o925640.ingest.us.sentry.io/4507367420198912',
//        // Specify a fixed sample rate
//        'traces_sample_rate'   => 1.0,
//        // Set a sampling rate for profiling - this is relative to traces_sample_rate
//        'profiles_sample_rate' => 1.0,
//    ]);
//
//    $bugsnag = \Bugsnag\Client::make('52097ad64bdcf58cddef344bff81e54e');
//    \Bugsnag\Handler::registerWithPrevious($bugsnag);
//
//});

Events::on('pre_system', static function () {
    if (ENVIRONMENT !== 'testing') {
        if (ini_get('zlib.output_compression')) {
            throw FrameworkException::forEnabledZlibOutputCompression();
        }

        while (ob_get_level() > 0) {
            ob_end_flush();
        }

        ob_start(static fn($buffer) => $buffer);
    }

    /*
     * --------------------------------------------------------------------
     * Debug Toolbar Listeners.
     * --------------------------------------------------------------------
     * If you delete, they will no longer be collected.
     */
    if (CI_DEBUG && !is_cli()) {
        Events::on('DBQuery', 'CodeIgniter\Debug\Toolbar\Collectors\Database::collect');
        Services::toolbar() -> respond();
        // Hot Reload route - for framework use on the hot reloader.
        if (ENVIRONMENT === 'development') {
            Services::routes() -> get('__hot-reload', static function () {
                (new HotReloader()) -> run();
            });
        }
    }
});
